/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.timeline.SegmentId;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Update;

@LazySingleton
public class SegmentSchemaManager {
    private static final EmittingLogger log = new EmittingLogger(SegmentSchemaManager.class);
    private static final int DB_ACTION_PARTITION_SIZE = 100;
    private final MetadataStorageTablesConfig dbTables;
    private final ObjectMapper jsonMapper;
    private final SQLMetadataConnector connector;

    @Inject
    public SegmentSchemaManager(MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper, SQLMetadataConnector connector) {
        this.dbTables = dbTables;
        this.jsonMapper = jsonMapper;
        this.connector = connector;
    }

    public List<String> findReferencedSchemaMarkedAsUnused() {
        return (List)this.connector.retryWithHandle(handle -> handle.createQuery(StringUtils.format((String)"SELECT DISTINCT(schema_fingerprint) FROM %s WHERE used = true AND schema_fingerprint IN (SELECT fingerprint FROM %s WHERE used = false)", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.dbTables.getSegmentSchemasTable()})).mapTo(String.class).list());
    }

    public int markSchemaAsUsed(List<String> schemaFingerprints) {
        if (schemaFingerprints.isEmpty()) {
            return 0;
        }
        String inClause = this.getInClause(schemaFingerprints.stream());
        return (Integer)this.connector.retryWithHandle(handle -> ((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET used = true, used_status_last_updated = :now WHERE fingerprint IN (%s)", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable(), inClause})).bind("now", DateTimes.nowUtc().toString())).execute());
    }

    public int deleteSchemasOlderThan(long timestamp) {
        return (Integer)this.connector.retryWithHandle(handle -> ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE used = false AND used_status_last_updated < :now", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable()})).bind("now", DateTimes.utc((long)timestamp).toString())).execute());
    }

    public int markUnreferencedSchemasAsUnused() {
        return (Integer)this.connector.retryWithHandle(handle -> ((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET used = false, used_status_last_updated = :now  WHERE used != false AND fingerprint NOT IN (SELECT DISTINCT(schema_fingerprint) FROM %s WHERE used=true AND schema_fingerprint IS NOT NULL)", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable(), this.dbTables.getSegmentsTable()})).bind("now", DateTimes.nowUtc().toString())).execute());
    }

    public void persistSchemaAndUpdateSegmentsTable(String dataSource, List<SegmentSchemaMetadataPlus> segmentSchemas, int version) {
        this.connector.retryTransaction((handle, status) -> {
            HashMap<String, SchemaPayload> schemaPayloadMap = new HashMap<String, SchemaPayload>();
            for (SegmentSchemaMetadataPlus segmentSchema : segmentSchemas) {
                schemaPayloadMap.put(segmentSchema.getFingerprint(), segmentSchema.getSegmentSchemaMetadata().getSchemaPayload());
            }
            this.persistSegmentSchema(handle, dataSource, version, schemaPayloadMap);
            this.updateSegmentWithSchemaInformation(handle, segmentSchemas);
            return null;
        }, 1, 3);
    }

    public void persistSegmentSchema(Handle handle, String dataSource, int version, Map<String, SchemaPayload> fingerprintSchemaPayloadMap) throws JsonProcessingException {
        HashSet unusedExistingFingerprints;
        if (fingerprintSchemaPayloadMap.isEmpty()) {
            return;
        }
        Map<Boolean, Set<String>> existingFingerprintsAndUsedStatus = this.fingerprintExistBatch(handle, fingerprintSchemaPayloadMap.keySet());
        Set<Object> usedExistingFingerprints = existingFingerprintsAndUsedStatus.containsKey(true) ? existingFingerprintsAndUsedStatus.get(true) : new HashSet();
        Sets.SetView existingFingerprints = Sets.union(usedExistingFingerprints, unusedExistingFingerprints = existingFingerprintsAndUsedStatus.containsKey(false) ? existingFingerprintsAndUsedStatus.get(false) : new HashSet());
        if (existingFingerprints.size() > 0) {
            log.info("Found already existing schema in the DB for dataSource [%1$s]. Used fingeprints: [%2$s], Unused fingerprints: [%3$s].", new Object[]{dataSource, usedExistingFingerprints, unusedExistingFingerprints});
        }
        if (unusedExistingFingerprints.size() > 0) {
            this.markSchemaAsUsed(new ArrayList<String>(unusedExistingFingerprints));
        }
        HashMap<String, SchemaPayload> schemaPayloadToPersist = new HashMap<String, SchemaPayload>();
        for (Map.Entry<String, SchemaPayload> entry : fingerprintSchemaPayloadMap.entrySet()) {
            if (existingFingerprints.contains(entry.getKey())) continue;
            schemaPayloadToPersist.put(entry.getKey(), entry.getValue());
        }
        if (schemaPayloadToPersist.isEmpty()) {
            log.info("No schema to persist for dataSource [%s] and version [%s].", new Object[]{dataSource, version});
            return;
        }
        List partitionedFingerprints = Lists.partition(new ArrayList(schemaPayloadToPersist.keySet()), (int)100);
        String insertSql = StringUtils.format((String)"INSERT INTO %s (created_date, datasource, fingerprint, payload, used, used_status_last_updated, version) VALUES (:created_date, :datasource, :fingerprint, :payload, :used, :used_status_last_updated, :version)", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable()});
        PreparedBatch schemaInsertBatch = handle.prepareBatch(insertSql);
        for (List partition : partitionedFingerprints) {
            for (String fingerprint : partition) {
                String now = DateTimes.nowUtc().toString();
                ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)schemaInsertBatch.add().bind("created_date", now)).bind("datasource", dataSource)).bind("fingerprint", fingerprint)).bind("payload", this.jsonMapper.writeValueAsBytes((Object)fingerprintSchemaPayloadMap.get(fingerprint)))).bind("used", true)).bind("used_status_last_updated", now)).bind("version", version);
            }
            int[] affectedRows = schemaInsertBatch.execute();
            ArrayList<String> failedInserts = new ArrayList<String>();
            for (int i = 0; i < partition.size(); ++i) {
                if (affectedRows[i] == 1) continue;
                failedInserts.add((String)partition.get(i));
            }
            if (failedInserts.isEmpty()) {
                log.info("Published schemas [%s] to DB for datasource [%s] and version [%s]", new Object[]{partition, dataSource, version});
                continue;
            }
            throw new ISE("Failed to publish schemas [%s] to DB for datasource [%s] and version [%s]", new Object[]{failedInserts, dataSource, version});
        }
    }

    public void updateSegmentWithSchemaInformation(Handle handle, List<SegmentSchemaMetadataPlus> batch) {
        log.debug("Updating segment with schemaFingerprint and numRows information: [%s].", new Object[]{batch});
        String updateSql = StringUtils.format((String)"UPDATE %s SET schema_fingerprint = :schema_fingerprint, num_rows = :num_rows WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()});
        PreparedBatch segmentUpdateBatch = handle.prepareBatch(updateSql);
        List partitionedSegmentIds = Lists.partition(batch, (int)100);
        for (List partition : partitionedSegmentIds) {
            for (SegmentSchemaMetadataPlus segmentSchema : partition) {
                String fingerprint = segmentSchema.getFingerprint();
                ((PreparedBatchPart)((PreparedBatchPart)segmentUpdateBatch.add().bind("id", segmentSchema.getSegmentId().toString())).bind("schema_fingerprint", fingerprint)).bind("num_rows", segmentSchema.getSegmentSchemaMetadata().getNumRows());
            }
            int[] affectedRows = segmentUpdateBatch.execute();
            ArrayList<SegmentId> failedUpdates = new ArrayList<SegmentId>();
            for (int i = 0; i < partition.size(); ++i) {
                if (affectedRows[i] == 1) continue;
                failedUpdates.add(((SegmentSchemaMetadataPlus)partition.get(i)).getSegmentId());
            }
            if (failedUpdates.isEmpty()) {
                log.infoSegmentIds(partition.stream().map(SegmentSchemaMetadataPlus::getSegmentId), "Updated segments with schema information in the DB");
                continue;
            }
            throw new ISE("Failed to update segments with schema information: %s", new Object[]{this.getCommaSeparatedIdentifiers(failedUpdates)});
        }
    }

    private Object getCommaSeparatedIdentifiers(Collection<SegmentId> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return Collections2.transform(ids, (Function)Functions.identity());
    }

    private Map<Boolean, Set<String>> fingerprintExistBatch(Handle handle, Set<String> fingerprintsToInsert) {
        if (fingerprintsToInsert.isEmpty()) {
            return Collections.emptyMap();
        }
        List partitionedFingerprints = Lists.partition(new ArrayList<String>(fingerprintsToInsert), (int)100);
        HashMap<Boolean, Set<String>> existingFingerprints = new HashMap<Boolean, Set<String>>();
        for (List fingerprintList : partitionedFingerprints) {
            String fingerprints = fingerprintList.stream().map(fingerprint -> "'" + StringEscapeUtils.escapeSql((String)fingerprint) + "'").collect(Collectors.joining(","));
            handle.createQuery(StringUtils.format((String)"SELECT used, fingerprint FROM %s WHERE fingerprint IN (%s)", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable(), fingerprints})).map((index, r, ctx) -> existingFingerprints.computeIfAbsent(r.getBoolean(1), value -> new HashSet()).add(r.getString(2))).list();
        }
        return existingFingerprints;
    }

    private String getInClause(Stream<String> ids) {
        return ids.map(value -> "'" + StringEscapeUtils.escapeSql((String)value) + "'").collect(Collectors.joining(","));
    }

    public static class SegmentSchemaMetadataPlus {
        private final SegmentId segmentId;
        private final String fingerprint;
        private final SchemaPayloadPlus schemaPayloadPlus;

        public SegmentSchemaMetadataPlus(SegmentId segmentId, String fingerprint, SchemaPayloadPlus schemaPayloadPlus) {
            this.segmentId = segmentId;
            this.schemaPayloadPlus = schemaPayloadPlus;
            this.fingerprint = fingerprint;
        }

        public SegmentId getSegmentId() {
            return this.segmentId;
        }

        public SchemaPayloadPlus getSegmentSchemaMetadata() {
            return this.schemaPayloadPlus;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public String toString() {
            return "SegmentSchemaMetadataPlus{segmentId='" + this.segmentId + '\'' + ", fingerprint='" + this.fingerprint + '\'' + ", schemaPayloadPlus=" + this.schemaPayloadPlus + '}';
        }
    }
}

