/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface TuningConfig {
    public static final boolean DEFAULT_LOG_PARSE_EXCEPTIONS = false;
    public static final AppendableIndexSpec DEFAULT_APPENDABLE_INDEX = new OnheapIncrementalIndex.Spec();
    public static final int DEFAULT_MAX_PARSE_EXCEPTIONS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_SAVED_PARSE_EXCEPTIONS = 0;
    public static final int DEFAULT_MAX_ROWS_IN_MEMORY_BATCH = 1000000;
    public static final int DEFAULT_MAX_ROWS_IN_MEMORY_REALTIME = 150000;
    public static final boolean DEFAULT_SKIP_BYTES_IN_MEMORY_OVERHEAD_CHECK = false;
    public static final long DEFAULT_AWAIT_SEGMENT_AVAILABILITY_TIMEOUT_MILLIS = 0L;

    public AppendableIndexSpec getAppendableIndexSpec();

    public int getMaxRowsInMemory();

    public long getMaxBytesInMemory();

    default public long getMaxBytesInMemoryOrDefault() {
        long maxBytesInMemory = this.getMaxBytesInMemory();
        if (maxBytesInMemory > 0L) {
            return maxBytesInMemory;
        }
        if (maxBytesInMemory == 0L) {
            return this.getAppendableIndexSpec().getDefaultMaxBytesInMemory();
        }
        return Long.MAX_VALUE;
    }

    public PartitionsSpec getPartitionsSpec();

    public IndexSpec getIndexSpec();

    public IndexSpec getIndexSpecForIntermediatePersists();
}

