/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.rpc.ServiceLocation;

public class ServiceLocations {
    private final Set<ServiceLocation> locations;
    private final boolean closed;

    private ServiceLocations(Set<ServiceLocation> locations, boolean closed) {
        this.locations = (Set)Preconditions.checkNotNull(locations, (Object)"locations");
        this.closed = closed;
        if (closed && !locations.isEmpty()) {
            throw new IAE("Locations must be empty for closed services", new Object[0]);
        }
    }

    public static ServiceLocations forLocation(ServiceLocation location) {
        return new ServiceLocations(Collections.singleton((ServiceLocation)Preconditions.checkNotNull((Object)location)), false);
    }

    public static ServiceLocations forLocations(Set<ServiceLocation> locations) {
        return new ServiceLocations(locations, false);
    }

    public static ServiceLocations closed() {
        return new ServiceLocations(Collections.emptySet(), true);
    }

    public Set<ServiceLocation> getLocations() {
        return this.locations;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLocations that = (ServiceLocations)o;
        return this.closed == that.closed && Objects.equals(this.locations, that.locations);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.closed);
    }

    public String toString() {
        return "ServiceLocations{locations=" + this.locations + ", closed=" + this.closed + '}';
    }
}

