/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CollectionUtils;

public class SegmentPublishResult {
    private final Set<DataSegment> segments;
    private final boolean success;
    @Nullable
    private final String errorMsg;
    @Nullable
    private final List<PendingSegmentRecord> upgradedPendingSegments;

    public static SegmentPublishResult ok(Set<DataSegment> segments) {
        return new SegmentPublishResult(segments, true, null);
    }

    public static SegmentPublishResult ok(Set<DataSegment> segments, List<PendingSegmentRecord> upgradedPendingSegments) {
        return new SegmentPublishResult(segments, true, null, upgradedPendingSegments);
    }

    public static SegmentPublishResult fail(String errorMsg) {
        return new SegmentPublishResult((Set<DataSegment>)ImmutableSet.of(), false, errorMsg);
    }

    @JsonCreator
    private SegmentPublishResult(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="success") boolean success, @JsonProperty(value="errorMsg") @Nullable String errorMsg) {
        this(segments, success, errorMsg, null);
    }

    private SegmentPublishResult(Set<DataSegment> segments, boolean success, @Nullable String errorMsg, List<PendingSegmentRecord> upgradedPendingSegments) {
        this.segments = (Set)Preconditions.checkNotNull(segments, (Object)"segments");
        this.success = success;
        this.errorMsg = errorMsg;
        this.upgradedPendingSegments = upgradedPendingSegments;
        if (!success) {
            Preconditions.checkArgument((boolean)segments.isEmpty(), (Object)"segments must be empty for unsuccessful publishes");
            Preconditions.checkArgument((boolean)CollectionUtils.isNullOrEmpty(upgradedPendingSegments), (Object)"upgraded pending segments must be null or empty for unsuccessful publishes");
        }
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.success;
    }

    @JsonProperty
    @Nullable
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Nullable
    public List<PendingSegmentRecord> getUpgradedPendingSegments() {
        return this.upgradedPendingSegments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPublishResult that = (SegmentPublishResult)o;
        return this.success == that.success && Objects.equals(this.segments, that.segments) && Objects.equals(this.errorMsg, that.errorMsg);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.success, this.errorMsg);
    }

    public String toString() {
        return "SegmentPublishResult{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", success=" + this.success + ", errorMsg='" + this.errorMsg + '\'' + '}';
    }
}

