/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;

public class ClientCompactionRunnerInfo {
    private final CompactionEngine type;

    @JsonCreator
    public ClientCompactionRunnerInfo(@JsonProperty(value="type") CompactionEngine type) {
        this.type = type;
    }

    @JsonProperty
    public CompactionEngine getType() {
        return this.type;
    }

    public String toString() {
        return "ClientCompactionRunnerInfo{type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionRunnerInfo that = (ClientCompactionRunnerInfo)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public static CompactionConfigValidationResult validateCompactionConfig(DataSourceCompactionConfig newConfig, CompactionEngine defaultCompactionEngine) {
        CompactionEngine compactionEngine;
        CompactionEngine compactionEngine2 = compactionEngine = newConfig.getEngine() == null ? defaultCompactionEngine : newConfig.getEngine();
        if (compactionEngine == CompactionEngine.NATIVE) {
            return CompactionConfigValidationResult.success();
        }
        return ClientCompactionRunnerInfo.compactionConfigSupportedByMSQEngine(newConfig);
    }

    private static CompactionConfigValidationResult compactionConfigSupportedByMSQEngine(DataSourceCompactionConfig newConfig) {
        ArrayList<CompactionConfigValidationResult> validationResults = new ArrayList<CompactionConfigValidationResult>();
        if (newConfig.getTuningConfig() != null) {
            validationResults.add(ClientCompactionRunnerInfo.validatePartitionsSpecForMSQ(newConfig.getTuningConfig().getPartitionsSpec(), newConfig.getDimensionsSpec() == null ? null : newConfig.getDimensionsSpec().getDimensions()));
        }
        if (newConfig.getGranularitySpec() != null) {
            validationResults.add(ClientCompactionRunnerInfo.validateRollupForMSQ(newConfig.getMetricsSpec(), newConfig.getGranularitySpec().isRollup()));
        }
        validationResults.add(ClientCompactionRunnerInfo.validateMaxNumTasksForMSQ(newConfig.getTaskContext()));
        validationResults.add(ClientCompactionRunnerInfo.validateMetricsSpecForMSQ(newConfig.getMetricsSpec()));
        return validationResults.stream().filter(result -> !result.isValid()).findFirst().orElse(CompactionConfigValidationResult.success());
    }

    public static CompactionConfigValidationResult validatePartitionsSpecForMSQ(@Nullable PartitionsSpec partitionsSpec, @Nullable List<DimensionSchema> dimensionSchemas) {
        if (!(partitionsSpec instanceof DimensionRangePartitionsSpec) && !(partitionsSpec instanceof DynamicPartitionsSpec)) {
            return CompactionConfigValidationResult.failure("MSQ: Invalid partitioning type[%s]. Must be either 'dynamic' or 'range'", partitionsSpec.getClass().getSimpleName());
        }
        if (partitionsSpec instanceof DynamicPartitionsSpec && ((DynamicPartitionsSpec)partitionsSpec).getMaxTotalRows() != null) {
            return CompactionConfigValidationResult.failure("MSQ: 'maxTotalRows' not supported with 'dynamic' partitioning", new Object[0]);
        }
        if (partitionsSpec instanceof DimensionRangePartitionsSpec && dimensionSchemas != null) {
            Map dimensionSchemaMap = dimensionSchemas.stream().collect(Collectors.toMap(DimensionSchema::getName, Function.identity()));
            Optional<String> nonStringDimension = ((DimensionRangePartitionsSpec)partitionsSpec).getPartitionDimensions().stream().filter(dim -> !ColumnType.STRING.equals((Object)((DimensionSchema)dimensionSchemaMap.get(dim)).getColumnType())).findAny();
            if (nonStringDimension.isPresent()) {
                return CompactionConfigValidationResult.failure("MSQ: Non-string partition dimension[%s] of type[%s] not supported with 'range' partition spec", nonStringDimension.get(), ((DimensionSchema)dimensionSchemaMap.get(nonStringDimension.get())).getTypeName());
            }
        }
        return CompactionConfigValidationResult.success();
    }

    public static CompactionConfigValidationResult validateRollupForMSQ(AggregatorFactory[] metricsSpec, @Nullable Boolean isRollup) {
        if ((metricsSpec != null && metricsSpec.length > 0) != Boolean.TRUE.equals(isRollup)) {
            return CompactionConfigValidationResult.failure("MSQ: 'granularitySpec.rollup' must be true if and only if 'metricsSpec' is specified", new Object[0]);
        }
        return CompactionConfigValidationResult.success();
    }

    public static CompactionConfigValidationResult validateMaxNumTasksForMSQ(Map<String, Object> context) {
        int maxNumTasks;
        if (context != null && (maxNumTasks = QueryContext.of(context).getInt("maxNumTasks", 2)) < 2) {
            return CompactionConfigValidationResult.failure("MSQ: Context maxNumTasks[%,d] must be at least 2 (1 controller + 1 worker)", maxNumTasks);
        }
        return CompactionConfigValidationResult.success();
    }

    public static CompactionConfigValidationResult validateMetricsSpecForMSQ(AggregatorFactory[] metricsSpec) {
        if (metricsSpec == null) {
            return CompactionConfigValidationResult.success();
        }
        return Arrays.stream(metricsSpec).filter(aggregatorFactory -> !aggregatorFactory.equals(aggregatorFactory.getCombiningFactory())).findFirst().map(aggregatorFactory -> CompactionConfigValidationResult.failure("MSQ: Aggregator[%s] not supported in 'metricsSpec'", aggregatorFactory.getName())).orElse(CompactionConfigValidationResult.success());
    }
}

