/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup.namespace;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CSVParser;
import org.apache.druid.java.util.common.parsers.DelimitedParser;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathParser;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.Parser;
import org.apache.druid.query.lookup.namespace.ExtractionNamespace;
import org.joda.time.Period;

@JsonTypeName(value="uri")
public class UriExtractionNamespace
implements ExtractionNamespace {
    private static final Logger LOG = new Logger(UriExtractionNamespace.class);
    long DEFAULT_MAX_HEAP_PERCENTAGE = 10L;
    @JsonProperty
    private final URI uri;
    @JsonProperty
    private final URI uriPrefix;
    @JsonProperty
    private final FlatDataParser namespaceParseSpec;
    @JsonProperty
    private final String fileRegex;
    @JsonProperty
    private final Period pollPeriod;
    @JsonProperty
    private final Long maxHeapPercentage;

    @JsonCreator
    public UriExtractionNamespace(@JsonProperty(value="uri", required=false) URI uri, @JsonProperty(value="uriPrefix", required=false) URI uriPrefix, @JsonProperty(value="fileRegex", required=false) String fileRegex, @JsonProperty(value="namespaceParseSpec", required=true) FlatDataParser namespaceParseSpec, @Min(value=0L) @JsonProperty(value="pollPeriod", required=false) @Nullable @Min(value=0L) Period pollPeriod, @Deprecated @JsonProperty(value="versionRegex", required=false) String versionRegex, @JsonProperty(value="maxHeapPercentage") @Nullable Long maxHeapPercentage) {
        this.uri = uri;
        this.uriPrefix = uriPrefix;
        if (uri != null == (uriPrefix != null)) {
            throw new IAE("Either uri xor uriPrefix required", new Object[0]);
        }
        this.namespaceParseSpec = (FlatDataParser)Preconditions.checkNotNull((Object)namespaceParseSpec, (Object)"namespaceParseSpec");
        if (pollPeriod == null) {
            LOG.warn("No pollPeriod configured for UriExtractionNamespace - entries will be loaded only once at startup", new Object[0]);
            this.pollPeriod = Period.ZERO;
        } else {
            this.pollPeriod = pollPeriod;
        }
        String string = this.fileRegex = fileRegex == null ? versionRegex : fileRegex;
        if (fileRegex != null && versionRegex != null) {
            throw new IAE("Cannot specify both versionRegex and fileRegex. versionRegex is deprecated", new Object[0]);
        }
        if (uri != null && this.fileRegex != null) {
            throw new IAE("Cannot define both uri and fileRegex", new Object[0]);
        }
        if (this.fileRegex != null) {
            try {
                Pattern.compile(this.fileRegex);
            }
            catch (PatternSyntaxException ex) {
                throw new IAE((Throwable)ex, "Could not parse `fileRegex` [%s]", new Object[]{this.fileRegex});
            }
        }
        this.maxHeapPercentage = maxHeapPercentage == null ? this.DEFAULT_MAX_HEAP_PERCENTAGE : maxHeapPercentage;
    }

    public String getFileRegex() {
        return this.fileRegex;
    }

    public FlatDataParser getNamespaceParseSpec() {
        return this.namespaceParseSpec;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getUriPrefix() {
        return this.uriPrefix;
    }

    @Override
    public long getPollMs() {
        return this.pollPeriod.toStandardDuration().getMillis();
    }

    @Override
    public long getMaxHeapPercentage() {
        return this.maxHeapPercentage;
    }

    public String toString() {
        return "UriExtractionNamespace{uri=" + this.uri + ", uriPrefix=" + this.uriPrefix + ", namespaceParseSpec=" + this.namespaceParseSpec + ", fileRegex='" + this.fileRegex + '\'' + ", pollPeriod=" + this.pollPeriod + ", maxHeapPercentage=" + this.maxHeapPercentage + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriExtractionNamespace that = (UriExtractionNamespace)o;
        if (this.getUri() != null ? !this.getUri().equals(that.getUri()) : that.getUri() != null) {
            return false;
        }
        if (this.getUriPrefix() != null ? !this.getUriPrefix().equals(that.getUriPrefix()) : that.getUriPrefix() != null) {
            return false;
        }
        if (!this.getNamespaceParseSpec().equals(that.getNamespaceParseSpec())) {
            return false;
        }
        if (this.getFileRegex() != null ? !this.getFileRegex().equals(that.getFileRegex()) : that.getFileRegex() != null) {
            return false;
        }
        return this.pollPeriod.equals((Object)that.pollPeriod) && Objects.equals(this.maxHeapPercentage, that.maxHeapPercentage);
    }

    public int hashCode() {
        int result = this.getUri() != null ? this.getUri().hashCode() : 0;
        result = 31 * result + (this.getUriPrefix() != null ? this.getUriPrefix().hashCode() : 0);
        result = 31 * result + this.getNamespaceParseSpec().hashCode();
        result = 31 * result + (this.getFileRegex() != null ? this.getFileRegex().hashCode() : 0);
        result = 31 * result + this.pollPeriod.hashCode();
        result = 31 * result * Objects.hashCode(this.maxHeapPercentage);
        return result;
    }

    @JsonTypeName(value="simpleJson")
    public static class ObjectMapperFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;

        @JsonCreator
        public ObjectMapperFlatDataParser(@JacksonInject @Json ObjectMapper jsonMapper) {
            final JsonFactory jsonFactory = jsonMapper.getFactory().copy();
            jsonFactory.configure(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES, false);
            this.parser = new Parser<String, String>(){

                public Map<String, String> parseToMap(String input) {
                    try {
                        return (Map)jsonFactory.createParser(input).readValueAs(JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void setFieldNames(Iterable<String> fieldNames) {
                    throw new UOE("No field names available", new Object[0]);
                }

                public List<String> getFieldNames() {
                    throw new UOE("No field names available", new Object[0]);
                }
            };
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "ObjectMapperFlatDataParser{}";
        }
    }

    @JsonTypeName(value="customJson")
    public static class JSONFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final String keyFieldName;
        private final String valueFieldName;

        @JsonCreator
        public JSONFlatDataParser(@JacksonInject @Json ObjectMapper jsonMapper, @JsonProperty(value="keyFieldName") String keyFieldName, @JsonProperty(value="valueFieldName") String valueFieldName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyFieldName) ? 1 : 0) != 0, (Object)"[keyFieldName] cannot be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)valueFieldName) ? 1 : 0) != 0, (Object)"[valueFieldName] cannot be empty");
            this.keyFieldName = keyFieldName;
            this.valueFieldName = valueFieldName;
            this.parser = new DelegateParser((Parser)new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, keyFieldName, keyFieldName), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, valueFieldName, valueFieldName))), jsonMapper.copy(), false), keyFieldName, valueFieldName);
        }

        @JsonProperty
        public String getKeyFieldName() {
            return this.keyFieldName;
        }

        @JsonProperty
        public String getValueFieldName() {
            return this.valueFieldName;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSONFlatDataParser that = (JSONFlatDataParser)o;
            return Objects.equals(this.keyFieldName, that.keyFieldName) && Objects.equals(this.valueFieldName, that.valueFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.keyFieldName, this.valueFieldName);
        }

        public String toString() {
            return "JSONFlatDataParser{keyFieldName='" + this.keyFieldName + '\'' + ", valueFieldName='" + this.valueFieldName + '\'' + '}';
        }
    }

    @JsonTypeName(value="tsv")
    public static class TSVFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final List<String> columns;
        private final String delimiter;
        private final String listDelimiter;
        private final String keyColumn;
        private final String valueColumn;

        @JsonCreator
        public TSVFlatDataParser(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn, @JsonProperty(value="hasHeaderRow") boolean hasHeaderRow, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
            Preconditions.checkArgument((((List)Preconditions.checkNotNull(columns, (Object)"`columns` list required")).size() > 1 ? 1 : 0) != 0, (Object)"Must specify more than one column to have a key value pair");
            DelimitedParser delegate = new DelimitedParser(StringUtils.emptyToNullNonDruidDataString((String)delimiter), StringUtils.emptyToNullNonDruidDataString((String)listDelimiter), hasHeaderRow, skipHeaderRows);
            delegate.startFileFromBeginning();
            Preconditions.checkArgument((!(Strings.isNullOrEmpty((String)keyColumn) ^ Strings.isNullOrEmpty((String)valueColumn)) ? 1 : 0) != 0, (Object)"Must specify both `keyColumn` and `valueColumn` or neither `keyColumn` nor `valueColumn`");
            delegate.setFieldNames(columns);
            this.columns = columns;
            this.delimiter = delimiter;
            this.listDelimiter = listDelimiter;
            this.keyColumn = Strings.isNullOrEmpty((String)keyColumn) ? columns.get(0) : keyColumn;
            this.valueColumn = Strings.isNullOrEmpty((String)valueColumn) ? columns.get(1) : valueColumn;
            Preconditions.checkArgument((boolean)columns.contains(this.keyColumn), (String)"Column [%s] not found int columns: %s", (Object)this.keyColumn, columns);
            Preconditions.checkArgument((boolean)columns.contains(this.valueColumn), (String)"Column [%s] not found int columns: %s", (Object)this.valueColumn, columns);
            this.parser = new DelegateParser((Parser)delegate, this.keyColumn, this.valueColumn);
        }

        @VisibleForTesting
        TSVFlatDataParser(List<String> columns, String delimiter, String listDelimiter, String keyColumn, String valueColumn) {
            this(columns, delimiter, listDelimiter, keyColumn, valueColumn, false, 0);
        }

        @JsonProperty
        public List<String> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public String getKeyColumn() {
            return this.keyColumn;
        }

        @JsonProperty
        public String getValueColumn() {
            return this.valueColumn;
        }

        @JsonProperty
        public String getListDelimiter() {
            return this.listDelimiter;
        }

        @JsonProperty
        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TSVFlatDataParser that = (TSVFlatDataParser)o;
            return Objects.equals(this.columns, that.columns) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.listDelimiter, that.listDelimiter) && Objects.equals(this.keyColumn, that.keyColumn) && Objects.equals(this.valueColumn, that.valueColumn);
        }

        public int hashCode() {
            return Objects.hash(this.columns, this.delimiter, this.listDelimiter, this.keyColumn, this.valueColumn);
        }

        public String toString() {
            return "TSVFlatDataParser{columns=" + this.columns + ", delimiter='" + this.delimiter + '\'' + ", listDelimiter='" + this.listDelimiter + '\'' + ", keyColumn='" + this.keyColumn + '\'' + ", valueColumn='" + this.valueColumn + '\'' + '}';
        }
    }

    @JsonTypeName(value="csv")
    public static class CSVFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final List<String> columns;
        private final String keyColumn;
        private final String valueColumn;

        @JsonCreator
        public CSVFlatDataParser(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn, @JsonProperty(value="hasHeaderRow") boolean hasHeaderRow, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
            Preconditions.checkArgument((((List)Preconditions.checkNotNull(columns, (Object)"`columns` list required")).size() > 1 ? 1 : 0) != 0, (Object)"Must specify more than one column to have a key value pair");
            Preconditions.checkArgument((!(Strings.isNullOrEmpty((String)keyColumn) ^ Strings.isNullOrEmpty((String)valueColumn)) ? 1 : 0) != 0, (Object)"Must specify both `keyColumn` and `valueColumn` or neither `keyColumn` nor `valueColumn`");
            this.columns = columns;
            this.keyColumn = Strings.isNullOrEmpty((String)keyColumn) ? columns.get(0) : keyColumn;
            this.valueColumn = Strings.isNullOrEmpty((String)valueColumn) ? columns.get(1) : valueColumn;
            Preconditions.checkArgument((boolean)columns.contains(this.keyColumn), (String)"Column [%s] not found int columns: %s", (Object)this.keyColumn, (Object)Arrays.toString(columns.toArray()));
            Preconditions.checkArgument((boolean)columns.contains(this.valueColumn), (String)"Column [%s] not found int columns: %s", (Object)this.valueColumn, (Object)Arrays.toString(columns.toArray()));
            CSVParser csvParser = new CSVParser(null, columns, hasHeaderRow, skipHeaderRows);
            csvParser.startFileFromBeginning();
            this.parser = new DelegateParser((Parser)csvParser, this.keyColumn, this.valueColumn);
        }

        @VisibleForTesting
        CSVFlatDataParser(List<String> columns, String keyColumn, String valueColumn) {
            this(columns, keyColumn, valueColumn, false, 0);
        }

        @JsonProperty
        public List<String> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public String getKeyColumn() {
            return this.keyColumn;
        }

        @JsonProperty
        public String getValueColumn() {
            return this.valueColumn;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CSVFlatDataParser that = (CSVFlatDataParser)o;
            return Objects.equals(this.columns, that.columns) && Objects.equals(this.keyColumn, that.keyColumn) && Objects.equals(this.valueColumn, that.valueColumn);
        }

        public int hashCode() {
            return Objects.hash(this.columns, this.keyColumn, this.valueColumn);
        }

        public String toString() {
            return "CSVFlatDataParser{columns=" + this.columns + ", keyColumn='" + this.keyColumn + '\'' + ", valueColumn='" + this.valueColumn + '\'' + '}';
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="format")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="csv", value=CSVFlatDataParser.class), @JsonSubTypes.Type(name="tsv", value=TSVFlatDataParser.class), @JsonSubTypes.Type(name="customJson", value=JSONFlatDataParser.class), @JsonSubTypes.Type(name="simpleJson", value=ObjectMapperFlatDataParser.class)})
    public static interface FlatDataParser {
        public Parser<String, String> getParser();
    }

    private static class DelegateParser
    implements Parser<String, String> {
        private final Parser<String, Object> delegate;
        private final String key;
        private final String value;

        private DelegateParser(Parser<String, Object> delegate, @NotNull String key, @NotNull String value) {
            this.delegate = delegate;
            this.key = key;
            this.value = value;
        }

        public Map<String, String> parseToMap(String input) {
            Map inner = this.delegate.parseToMap(input);
            if (null == inner) {
                return ImmutableMap.of();
            }
            String k = Preconditions.checkNotNull(inner.get(this.key), (String)"Key column [%s] missing data in line [%s]", (Object)this.key, (Object)input).toString();
            Object val = inner.get(this.value);
            if (val == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.of((Object)k, (Object)val.toString());
        }

        public void setFieldNames(Iterable<String> fieldNames) {
            this.delegate.setFieldNames(fieldNames);
        }

        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }
    }
}

