/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics.serde;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.statistics.DelegateOrMinKeyCollectorSnapshot;
import org.apache.druid.msq.statistics.DistinctKeySnapshot;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.QuantilesSketchKeyCollectorSnapshot;

public class KeyCollectorSnapshotDeserializer {
    private static final ImmutableMap<Byte, Function<ByteBuffer, KeyCollectorSnapshot>> DESERIALIZERS = ImmutableMap.builder().put((Object)2, QuantilesSnapshotDeserializer::deserialize).put((Object)0, DelegateOrMinDeserializer::deserialize).put((Object)1, DistinctSnapshotDeserializer::deserialize).build();

    public static KeyCollectorSnapshot deserialize(ByteBuffer byteBuffer) {
        int position = byteBuffer.position();
        byte type = byteBuffer.get(position);
        byteBuffer.position(position + 1);
        return (KeyCollectorSnapshot)((Function)DESERIALIZERS.get((Object)type)).apply(byteBuffer);
    }

    static class QuantilesSnapshotDeserializer {
        private static final int AVG_KEY_LENGTH_OFFSET = 0;
        private static final int SKETCH_LENGTH_OFFSET = 8;
        private static final int SKETCH_OFFSET = 12;

        QuantilesSnapshotDeserializer() {
        }

        public static QuantilesSketchKeyCollectorSnapshot deserialize(ByteBuffer byteBuffer) {
            int position = byteBuffer.position();
            double avgKeyLength = byteBuffer.getDouble(position + 0);
            int sketchLength = byteBuffer.getInt(position + 8);
            byte[] sketchBytes = new byte[sketchLength];
            byteBuffer.position(position + 12);
            byteBuffer.get(sketchBytes);
            String sketch = StringUtils.encodeBase64String((byte[])sketchBytes);
            return new QuantilesSketchKeyCollectorSnapshot(sketch, avgKeyLength);
        }
    }

    static class DistinctSnapshotDeserializer {
        private static final int SPACE_REDUCTION_FACTOR_OFFSET = 0;
        private static final int LIST_LENGTH_OFFSET = 4;
        private static final int LIST_OFFSET = 8;
        private static final int WEIGHT_OFFSET = 0;
        private static final int KEY_LENGTH_OFFSET = 8;
        private static final int KEY_OFFSET = 12;

        DistinctSnapshotDeserializer() {
        }

        public static KeyCollectorSnapshot deserialize(ByteBuffer byteBuffer) {
            int position = byteBuffer.position();
            int spaceReductionFactor = byteBuffer.getInt(position + 0);
            int listLength = byteBuffer.getInt(position + 4);
            ArrayList<SerializablePair<RowKey, Long>> keys = new ArrayList<SerializablePair<RowKey, Long>>();
            position = byteBuffer.position(position + 8).position();
            for (int i = 0; i < listLength; ++i) {
                long weight = byteBuffer.getLong(position + 0);
                int keyLength = byteBuffer.getInt(position + 8);
                ByteBuffer duplicate = (ByteBuffer)byteBuffer.duplicate().order(byteBuffer.order()).position(position + 12).limit(position + 12 + keyLength);
                byte[] key = new byte[keyLength];
                duplicate.get(key);
                keys.add((SerializablePair<RowKey, Long>)new SerializablePair((Object)RowKey.wrap((byte[])key), (Object)weight));
                position = byteBuffer.position(position + 12 + keyLength).position();
            }
            return new DistinctKeySnapshot(keys, spaceReductionFactor);
        }
    }

    static class DelegateOrMinDeserializer {
        private static final int TYPE_OFFSET = 0;
        private static final int ARRAY_LENGTH_OFFSET = 1;
        private static final int ARRAY_OFFSET = 5;

        DelegateOrMinDeserializer() {
        }

        public static KeyCollectorSnapshot deserialize(ByteBuffer byteBuffer) {
            int position = byteBuffer.position();
            byte type = byteBuffer.get(position + 0);
            int length = byteBuffer.getInt(position + 1);
            ByteBuffer duplicate = (ByteBuffer)byteBuffer.duplicate().order(byteBuffer.order()).position(position + 5).limit(position + 5 + length);
            if (type == 0) {
                byte[] rowKey = new byte[length];
                duplicate.get(rowKey, 0, length);
                return new DelegateOrMinKeyCollectorSnapshot<Object>(null, RowKey.wrap((byte[])rowKey));
            }
            if (type == 1) {
                return new DelegateOrMinKeyCollectorSnapshot<KeyCollectorSnapshot>(KeyCollectorSnapshotDeserializer.deserialize(duplicate), null);
            }
            throw new UnsupportedOperationException();
        }
    }
}

