/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.TooManyRowsWithSameKeyFault;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;

public class SortMergeJoinFrameProcessor
implements FrameProcessor<Object> {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private final List<ReadableFrameChannel> inputChannels;
    private final List<Tracker> trackers;
    private final WritableFrameChannel outputChannel;
    private final FrameWriterFactory frameWriterFactory;
    private final String rightPrefix;
    private final JoinType joinType;
    private final JoinColumnSelectorFactory joinColumnSelectorFactory = new JoinColumnSelectorFactory();
    private final long maxBufferedBytes;
    private FrameWriter frameWriter = null;
    private Runnable nextIterationRunnable = null;
    private int trackerWithCompleteSetForCurrentKey = -1;

    SortMergeJoinFrameProcessor(ReadableInput left, ReadableInput right, WritableFrameChannel outputChannel, FrameWriterFactory frameWriterFactory, String rightPrefix, List<List<KeyColumn>> keyColumns, int[] requiredNonNullKeyParts, JoinType joinType, long maxBufferedBytes) {
        this.inputChannels = ImmutableList.of((Object)left.getChannel(), (Object)right.getChannel());
        this.outputChannel = outputChannel;
        this.frameWriterFactory = frameWriterFactory;
        this.rightPrefix = rightPrefix;
        this.joinType = joinType;
        this.trackers = ImmutableList.of((Object)new Tracker(left, keyColumns.get(0), requiredNonNullKeyParts, maxBufferedBytes), (Object)new Tracker(right, keyColumns.get(1), requiredNonNullKeyParts, maxBufferedBytes));
        this.maxBufferedBytes = maxBufferedBytes;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        for (int i = 0; i < this.inputChannels.size(); ++i) {
            Tracker tracker = this.trackers.get(i);
            if (!tracker.needsMoreDataForCurrentCursor() || this.pushNextFrame(i)) continue;
            return this.nextAwait();
        }
        this.startNewFrameIfNeeded();
        while (!(this.allTrackersAreAtEnd() || this.trackers.get(0).needsMoreDataForCurrentCursor() || this.trackers.get(1).needsMoreDataForCurrentCursor())) {
            int markCmp;
            boolean marksMatch;
            if (this.nextIterationRunnable != null) {
                Runnable tmp = this.nextIterationRunnable;
                this.nextIterationRunnable = null;
                tmp.run();
            }
            boolean bl = marksMatch = (markCmp = this.compareMarks()) == 0 && this.trackers.get(0).markHasRequiredNonNullKeyParts();
            if (marksMatch && this.trackerWithCompleteSetForCurrentKey < 0) {
                this.updateTrackerWithCompleteSetForCurrentKey();
                if (this.trackerWithCompleteSetForCurrentKey < 0) {
                    return this.nextAwait();
                }
            }
            if (!this.emitRowIfNeeded(markCmp, marksMatch)) {
                return ReturnOrAwait.runAgain();
            }
            this.advanceTrackersAfterEmittingRow(markCmp, marksMatch);
        }
        if (this.allTrackersAreAtEnd()) {
            this.flushCurrentFrame();
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        return this.nextAwait();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[]{this.frameWriter, () -> this.trackers.forEach(Tracker::clear)});
    }

    private void updateTrackerWithCompleteSetForCurrentKey() {
        for (int i = 0; i < this.inputChannels.size(); ++i) {
            Tracker tracker = this.trackers.get(i);
            if (!tracker.hasCompleteSetForMark() && (!this.pushNextFrame(i) || !tracker.hasCompleteSetForMark())) continue;
            this.trackerWithCompleteSetForCurrentKey = i;
            return;
        }
        this.trackerWithCompleteSetForCurrentKey = -1;
    }

    private boolean emitRowIfNeeded(int markCmp, boolean marksMatch) throws IOException {
        if (marksMatch || markCmp <= 0 && this.joinType.isLefty() || markCmp >= 0 && this.joinType.isRighty()) {
            this.joinColumnSelectorFactory.cmp = markCmp;
            this.joinColumnSelectorFactory.match = marksMatch;
            if (!this.frameWriter.addSelection()) {
                if (this.frameWriter.getNumRows() > 0) {
                    this.flushCurrentFrame();
                    return false;
                }
                throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
            }
        }
        return true;
    }

    private void advanceTrackersAfterEmittingRow(int markCmp, boolean marksMatch) {
        if (marksMatch) {
            Tracker completeSetTracker = this.trackers.get(this.trackerWithCompleteSetForCurrentKey);
            Tracker otherTracker = this.trackers.get(this.trackerWithCompleteSetForCurrentKey == 0 ? 1 : 0);
            completeSetTracker.advance();
            if (!completeSetTracker.isCurrentSameKeyAsMark()) {
                otherTracker.advance();
                this.onNextIteration(() -> {
                    if (otherTracker.isCurrentSameKeyAsMark()) {
                        completeSetTracker.rewindToMark();
                    } else {
                        completeSetTracker.markCurrent();
                        this.trackerWithCompleteSetForCurrentKey = -1;
                    }
                    otherTracker.markCurrent();
                });
            }
        } else {
            int trackerToAdvance;
            if (markCmp < 0) {
                trackerToAdvance = 0;
            } else if (markCmp > 0) {
                trackerToAdvance = 1;
            } else {
                int n = trackerToAdvance = this.joinType.isLefty() ? 0 : 1;
            }
            boolean skipMarkedKey = trackerToAdvance == 0 ? !this.joinType.isLefty() : !this.joinType.isRighty();
            Tracker tracker = this.trackers.get(trackerToAdvance);
            boolean didKeyChange = false;
            do {
                tracker.advance();
                if (tracker.isAtEndOfPushedData()) break;
                didKeyChange = !tracker.isCurrentSameKeyAsMark();
                tracker.markCurrent();
            } while (skipMarkedKey && !didKeyChange);
            if (didKeyChange) {
                this.trackerWithCompleteSetForCurrentKey = -1;
            } else if (tracker.isAtEndOfPushedData()) {
                this.onNextIteration(() -> {
                    if (!tracker.isCurrentSameKeyAsMark()) {
                        this.trackerWithCompleteSetForCurrentKey = -1;
                    }
                    tracker.markCurrent();
                });
            }
        }
    }

    private ReturnOrAwait<Object> nextAwait() {
        Tracker tracker;
        int i;
        IntOpenHashSet awaitSet = new IntOpenHashSet();
        int trackerAtLimit = -1;
        for (i = 0; i < this.inputChannels.size(); ++i) {
            tracker = this.trackers.get(i);
            if (!tracker.needsMoreDataForCurrentCursor()) continue;
            if (tracker.canBufferMoreFrames()) {
                awaitSet.add(i);
                continue;
            }
            if (trackerAtLimit >= 0) continue;
            trackerAtLimit = i;
        }
        if (awaitSet.isEmpty()) {
            for (i = 0; i < this.inputChannels.size(); ++i) {
                tracker = this.trackers.get(i);
                if (tracker.hasCompleteSetForMark()) continue;
                if (tracker.canBufferMoreFrames()) {
                    awaitSet.add(i);
                    continue;
                }
                if (trackerAtLimit >= 0) continue;
                trackerAtLimit = i;
            }
        }
        if (awaitSet.isEmpty() && trackerAtLimit >= 0) {
            Tracker tracker2 = this.trackers.get(trackerAtLimit);
            throw new MSQException(new TooManyRowsWithSameKeyFault(tracker2.readMarkKey(), tracker2.totalBytesBuffered(), this.maxBufferedBytes));
        }
        return ReturnOrAwait.awaitAll((IntSet)awaitSet);
    }

    private boolean allTrackersAreAtEnd() {
        for (Tracker tracker : this.trackers) {
            if (tracker.isAtEnd()) continue;
            return false;
        }
        return true;
    }

    private int compareMarks() {
        Tracker leftTracker = this.trackers.get(0);
        Tracker rightTracker = this.trackers.get(1);
        Preconditions.checkState((leftTracker.hasMark() || leftTracker.isAtEnd() ? 1 : 0) != 0, (Object)"left.hasMark || left.isAtEnd");
        Preconditions.checkState((rightTracker.hasMark() || rightTracker.isAtEnd() ? 1 : 0) != 0, (Object)"right.hasMark || right.isAtEnd");
        if (!leftTracker.hasMark()) {
            return rightTracker.markFrame < 0 ? 0 : 1;
        }
        if (!rightTracker.hasMark()) {
            return -1;
        }
        FrameHolder leftHolder = (FrameHolder)leftTracker.holders.get(leftTracker.markFrame);
        FrameHolder rightHolder = (FrameHolder)rightTracker.holders.get(rightTracker.markFrame);
        return leftHolder.comparisonWidget.compare(leftTracker.markRow, rightHolder.comparisonWidget, rightTracker.markRow);
    }

    private boolean pushNextFrame(int channelNumber) {
        ReadableFrameChannel channel = this.inputChannels.get(channelNumber);
        Tracker tracker = this.trackers.get(channelNumber);
        if (!channel.isFinished() && !channel.canRead()) {
            return false;
        }
        if (channel.isFinished()) {
            tracker.push(null);
            return true;
        }
        if (!tracker.canBufferMoreFrames()) {
            return false;
        }
        Frame frame = channel.read();
        if (frame.numRows() == 0) {
            return false;
        }
        tracker.push(frame);
        return true;
    }

    private void onNextIteration(Runnable runnable) {
        if (this.nextIterationRunnable != null) {
            throw new ISE("postAdvanceRunnable already set", new Object[0]);
        }
        this.nextIterationRunnable = runnable;
    }

    private void startNewFrameIfNeeded() {
        if (this.frameWriter == null) {
            this.frameWriter = this.frameWriterFactory.newFrameWriter((ColumnSelectorFactory)this.joinColumnSelectorFactory);
        }
    }

    private void flushCurrentFrame() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            this.frameWriter.close();
            this.frameWriter = null;
            this.outputChannel.write(new FrameWithPartition(frame, -1));
        }
    }

    private static class FrameHolder {
        private final Frame frame;
        private final RowKeyReader keyReader;
        private final FrameCursor cursor;
        private final FrameComparisonWidget comparisonWidget;

        public FrameHolder(Frame frame, RowKeyReader keyReader, FrameCursor cursor, FrameComparisonWidget comparisonWidget) {
            this.frame = frame;
            this.keyReader = keyReader;
            this.cursor = cursor;
            this.comparisonWidget = comparisonWidget;
        }
    }

    private class JoinColumnSelectorFactory
    implements ColumnSelectorFactory {
        private int cmp;
        private boolean match;

        private JoinColumnSelectorFactory() {
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            if (dimensionSpec.getExtractionFn() != null || dimensionSpec.mustDecorate()) {
                throw new UnsupportedOperationException();
            }
            int channel = this.getChannelNumber(dimensionSpec.getDimension());
            ColumnCapabilities columnCapabilities = this.getColumnCapabilities(dimensionSpec.getDimension());
            if (columnCapabilities == null) {
                return DimensionSelector.constant(null);
            }
            return new JoinDimensionSelector(channel, this.getInputColumnName(dimensionSpec.getDimension()));
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            int channel = this.getChannelNumber(columnName);
            ColumnCapabilities columnCapabilities = this.getColumnCapabilities(columnName);
            if (columnCapabilities == null) {
                return NilColumnValueSelector.instance();
            }
            return new JoinColumnValueSelector(channel, this.getInputColumnName(columnName));
        }

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return SortMergeJoinFrameProcessor.this.frameWriterFactory.signature().getColumnCapabilities(column);
        }

        private int getChannelNumber(String column) {
            if (JoinPrefixUtils.isPrefixedBy((String)column, (String)SortMergeJoinFrameProcessor.this.rightPrefix)) {
                return 1;
            }
            return 0;
        }

        private String getInputColumnName(String column) {
            if (JoinPrefixUtils.isPrefixedBy((String)column, (String)SortMergeJoinFrameProcessor.this.rightPrefix)) {
                return JoinPrefixUtils.unprefix((String)column, (String)SortMergeJoinFrameProcessor.this.rightPrefix);
            }
            return column;
        }

        private boolean shouldEmitColumnValue(int channel) {
            return !((Tracker)SortMergeJoinFrameProcessor.this.trackers.get(channel)).isAtEndOfPushedData() && (this.match || channel == 0 && SortMergeJoinFrameProcessor.this.joinType.isLefty() && this.cmp <= 0 || channel == 1 && SortMergeJoinFrameProcessor.this.joinType.isRighty() && (SortMergeJoinFrameProcessor.this.joinType.isLefty() && this.cmp > 0 || !SortMergeJoinFrameProcessor.this.joinType.isLefty() && this.cmp >= 0));
        }

        private class JoinColumnValueSelector
        implements ColumnValueSelector<Object> {
            private final int channel;
            private final String columnName;
            private Cursor currentCursor;
            private ColumnValueSelector<?> currentSelector;

            public JoinColumnValueSelector(int channel, String columnName) {
                this.channel = channel;
                this.columnName = columnName;
            }

            public long getLong() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.getLong();
                }
                return 0L;
            }

            public double getDouble() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.getDouble();
                }
                return 0.0;
            }

            public float getFloat() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.getFloat();
                }
                return 0.0f;
            }

            @Nullable
            public Object getObject() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.getObject();
                }
                return null;
            }

            public boolean isNull() {
                this.refreshCursor();
                return !JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel) || this.currentSelector.isNull();
            }

            public Class<?> classOfObject() {
                return Object.class;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                throw new UnsupportedOperationException();
            }

            private void refreshCursor() {
                FrameCursor headCursor = ((Tracker)SortMergeJoinFrameProcessor.this.trackers.get(this.channel)).currentCursor();
                if (this.currentCursor != headCursor) {
                    if (headCursor == null) {
                        this.currentCursor = null;
                        this.currentSelector = null;
                    } else {
                        this.currentCursor = headCursor;
                        this.currentSelector = headCursor.getColumnSelectorFactory().makeColumnValueSelector(this.columnName);
                    }
                }
            }
        }

        private class JoinDimensionSelector
        implements DimensionSelector {
            private final int channel;
            private final String columnName;
            private Cursor currentCursor;
            private DimensionSelector currentSelector;

            public JoinDimensionSelector(int channel, String columnName) {
                this.channel = channel;
                this.columnName = columnName;
            }

            @Nullable
            public Object getObject() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.getObject();
                }
                return null;
            }

            public IndexedInts getRow() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.getRow();
                }
                return ZeroIndexedInts.instance();
            }

            @Nullable
            public String lookupName(int id) {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.lookupName(id);
                }
                return null;
            }

            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.lookupNameUtf8(id);
                }
                return null;
            }

            public boolean supportsLookupNameUtf8() {
                this.refreshCursor();
                if (JoinColumnSelectorFactory.this.shouldEmitColumnValue(this.channel)) {
                    return this.currentSelector.supportsLookupNameUtf8();
                }
                return true;
            }

            public int getValueCardinality() {
                return -1;
            }

            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public Class<?> classOfObject() {
                return Object.class;
            }

            public ValueMatcher makeValueMatcher(@Nullable String value) {
                return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
            }

            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (DruidPredicateFactory)predicateFactory);
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                throw new UnsupportedOperationException();
            }

            private void refreshCursor() {
                FrameCursor headCursor = ((Tracker)SortMergeJoinFrameProcessor.this.trackers.get(this.channel)).currentCursor();
                if (this.currentCursor != headCursor) {
                    if (headCursor == null) {
                        this.currentCursor = null;
                        this.currentSelector = null;
                    } else {
                        this.currentCursor = headCursor;
                        this.currentSelector = headCursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.columnName));
                    }
                }
            }
        }
    }

    private static class Tracker {
        private final List<FrameHolder> holders = new ArrayList<FrameHolder>();
        private final ReadableInput input;
        private final List<KeyColumn> keyColumns;
        private final int[] requiredNonNullKeyParts;
        private final long maxBytesBuffered;
        private int markFrame = -1;
        private int markRow = -1;
        private int currentFrame = -1;
        private boolean done;

        public Tracker(ReadableInput input, List<KeyColumn> keyColumns, int[] requiredNonNullKeyParts, long maxBytesBuffered) {
            this.input = input;
            this.keyColumns = keyColumns;
            this.requiredNonNullKeyParts = requiredNonNullKeyParts;
            this.maxBytesBuffered = maxBytesBuffered;
        }

        public void push(Frame frame) {
            if (frame == null) {
                this.done = true;
                return;
            }
            if (this.done) {
                throw new ISE("Cannot push frames when already done", new Object[0]);
            }
            boolean atEndOfPushedData = this.isAtEndOfPushedData();
            FrameReader frameReader = this.input.getChannelFrameReader();
            FrameCursor cursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)frameReader);
            FrameComparisonWidget comparisonWidget = frameReader.makeComparisonWidget(frame, this.keyColumns);
            RowSignature.Builder keySignatureBuilder = RowSignature.builder();
            for (KeyColumn keyColumn : this.keyColumns) {
                keySignatureBuilder.add(keyColumn.columnName(), (ColumnType)frameReader.signature().getColumnType(keyColumn.columnName()).orElse(null));
            }
            this.holders.add(new FrameHolder(frame, RowKeyReader.create((RowSignature)keySignatureBuilder.build()), cursor, comparisonWidget));
            if (atEndOfPushedData) {
                int n = this.currentFrame = this.currentFrame < 0 ? 0 : this.currentFrame + 1;
            }
            if (this.markFrame < 0) {
                this.markFrame = this.currentFrame;
                this.markRow = 0;
            }
        }

        public long totalBytesBuffered() {
            long bytes = 0L;
            for (FrameHolder holder : this.holders) {
                bytes += holder.frame.numBytes();
            }
            return bytes;
        }

        public boolean canBufferMoreFrames() {
            return this.holders.size() <= 1 || this.totalBytesBuffered() < this.maxBytesBuffered;
        }

        @Nullable
        public FrameCursor currentCursor() {
            if (this.currentFrame < 0) {
                return null;
            }
            return this.holders.get(this.currentFrame).cursor;
        }

        public void advance() {
            assert (!this.isAtEndOfPushedData());
            FrameHolder currentHolder = this.holders.get(this.currentFrame);
            currentHolder.cursor.advance();
            if (currentHolder.cursor.isDone() && this.currentFrame + 1 < this.holders.size()) {
                ++this.currentFrame;
                this.holders.get(this.currentFrame).cursor.reset();
            }
        }

        public boolean hasMark() {
            return this.markFrame >= 0;
        }

        public boolean markHasRequiredNonNullKeyParts() {
            return this.hasMark() && this.holders.get(this.markFrame).comparisonWidget.hasNonNullKeyParts(this.markRow, this.requiredNonNullKeyParts);
        }

        @Nullable
        public List<Object> readMarkKey() {
            if (!this.hasMark()) {
                return null;
            }
            FrameHolder markHolder = this.holders.get(this.markFrame);
            RowKey markKey = markHolder.comparisonWidget.readKey(this.markRow);
            return markHolder.keyReader.read(markKey);
        }

        public void rewindToMark() {
            if (this.markFrame < 0) {
                throw new ISE("No mark", new Object[0]);
            }
            this.currentFrame = this.markFrame;
            this.holders.get(this.currentFrame).cursor.setCurrentRow(this.markRow);
        }

        public void markCurrent() {
            if (this.isAtEndOfPushedData()) {
                this.clear();
            } else {
                while (this.currentFrame > 0) {
                    if (this.currentFrame == this.holders.size() - 1) {
                        FrameHolder lastHolder = this.holders.get(this.currentFrame);
                        this.holders.clear();
                        this.holders.add(lastHolder);
                        this.currentFrame = 0;
                        continue;
                    }
                    this.holders.remove(0);
                    --this.currentFrame;
                }
                this.markFrame = 0;
                this.markRow = this.holders.get(this.currentFrame).cursor.getCurrentRow();
            }
        }

        public boolean isAtEndOfPushedData() {
            return this.currentFrame < 0 || this.currentFrame == this.holders.size() - 1 && this.holders.get(this.currentFrame).cursor.isDone();
        }

        public boolean isAtEnd() {
            return this.done && this.isAtEndOfPushedData();
        }

        public boolean needsMoreDataForCurrentCursor() {
            return !this.done && this.isAtEndOfPushedData();
        }

        public boolean hasCompleteSetForMark() {
            if (this.markFrame < 0) {
                throw new ISE("No mark", new Object[0]);
            }
            if (this.done) {
                return true;
            }
            FrameHolder lastHolder = this.holders.get(this.holders.size() - 1);
            return !this.isSameKeyAsMark(lastHolder, lastHolder.frame.numRows() - 1);
        }

        public boolean isCurrentSameKeyAsMark() {
            if (this.isAtEnd()) {
                return this.markFrame < 0;
            }
            assert (!this.isAtEndOfPushedData());
            FrameHolder headHolder = this.holders.get(this.currentFrame);
            return this.isSameKeyAsMark(headHolder, headHolder.cursor.getCurrentRow());
        }

        public void clear() {
            this.holders.clear();
            this.markFrame = -1;
            this.markRow = -1;
            this.currentFrame = -1;
        }

        private boolean isSameKeyAsMark(FrameHolder holder, int row) {
            if (this.markFrame < 0) {
                throw new ISE("No marked frame", new Object[0]);
            }
            if (row < 0 || row >= holder.frame.numRows()) {
                throw new ISE("Row [%d] out of bounds", new Object[]{row});
            }
            FrameHolder markHolder = this.holders.get(this.markFrame);
            int cmp = markHolder.comparisonWidget.compare(this.markRow, holder.comparisonWidget, row);
            if (cmp > 0) {
                throw new ISE("Row compares higher than mark; out-of-order input?", new Object[0]);
            }
            return cmp == 0;
        }
    }
}

