/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.HashShuffleSpec;
import org.apache.druid.msq.kernel.MixShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.DataSourcePlan;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.WindowOperatorQueryFrameProcessorFactory;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.NaivePartitioningOperatorFactory;
import org.apache.druid.query.operator.NaiveSortOperatorFactory;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.operator.window.WindowOperatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQueryKit
implements QueryKit<WindowOperatorQuery> {
    private static final Logger log = new Logger(WindowOperatorQueryKit.class);
    private final ObjectMapper jsonMapper;

    public WindowOperatorQueryKit(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryDefinition makeQueryDefinition(QueryKitSpec queryKitSpec, WindowOperatorQuery originalQuery, ShuffleSpecFactory resultShuffleSpecFactory, int minStageNumber) {
        RowSignature rowSignature = originalQuery.getRowSignature();
        log.info("Row signature received for query is [%s].", new Object[]{rowSignature});
        boolean isEmptyOverPresent = originalQuery.getOperators().stream().filter(of -> of instanceof NaivePartitioningOperatorFactory).map(of -> (NaivePartitioningOperatorFactory)of).anyMatch(of -> of.getPartitionColumns().isEmpty());
        List<List<OperatorFactory>> operatorList = this.getOperatorListFromQuery(originalQuery);
        log.info("Created operatorList with operator factories: [%s]", new Object[]{operatorList});
        DataSourcePlan dataSourcePlan = DataSourcePlan.forDataSource(queryKitSpec, originalQuery.context(), originalQuery.getDataSource(), originalQuery.getQuerySegmentSpec(), originalQuery.getFilter(), null, minStageNumber, false);
        ShuffleSpec nextShuffleSpec = this.findShuffleSpecForNextWindow(operatorList.get(0), queryKitSpec.getNumPartitionsForShuffle());
        QueryDefinitionBuilder queryDefBuilder = this.makeQueryDefinitionBuilder(queryKitSpec.getQueryId(), dataSourcePlan, nextShuffleSpec);
        int firstStageNumber = Math.max(minStageNumber, queryDefBuilder.getNextStageNumber());
        WindowOperatorQuery queryToRun = (WindowOperatorQuery)originalQuery.withDataSource(dataSourcePlan.getNewDataSource());
        Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(this.jsonMapper, queryToRun.getContext());
        ClusterBy finalWindowClusterBy = WindowOperatorQueryKit.computeClusterByForFinalWindowStage(segmentGranularity);
        ShuffleSpec finalWindowStageShuffleSpec = resultShuffleSpecFactory.build(finalWindowClusterBy, false);
        RowSignature finalWindowStageRowSignature = WindowOperatorQueryKit.computeSignatureForFinalWindowStage(rowSignature, finalWindowClusterBy, segmentGranularity);
        int maxRowsMaterialized = originalQuery.context() != null && originalQuery.context().containsKey("maxRowsMaterializedInWindow") ? (Integer)originalQuery.context().get("maxRowsMaterializedInWindow") : 100000;
        if (isEmptyOverPresent) {
            log.info("Empty over clause is present in the query. Creating a single stage with all operator factories [%s].", new Object[]{queryToRun.getOperators()});
            queryDefBuilder.add(StageDefinition.builder(firstStageNumber).inputs(new StageInputSpec(firstStageNumber - 1)).signature(finalWindowStageRowSignature).maxWorkerCount(queryKitSpec.getMaxNonLeafWorkerCount()).shuffleSpec(finalWindowStageShuffleSpec).processorFactory(new WindowOperatorQueryFrameProcessorFactory(queryToRun, queryToRun.getOperators(), finalWindowStageRowSignature, maxRowsMaterialized, Collections.emptyList())));
        } else {
            RowSignature.Builder bob = RowSignature.builder();
            RowSignature signatureFromInput = dataSourcePlan.getSubQueryDefBuilder().get().build().getFinalStageDefinition().getSignature();
            log.info("Row signature received from last stage is [%s].", new Object[]{signatureFromInput});
            for (int i = 0; i < signatureFromInput.getColumnNames().size(); ++i) {
                bob.add(signatureFromInput.getColumnName(i), (ColumnType)signatureFromInput.getColumnType(i).get());
            }
            ArrayList<String> partitionColumnNames = new ArrayList<String>();
            for (int i = 0; i < operatorList.size(); ++i) {
                RowSignature stageRowSignature;
                for (OperatorFactory operatorFactory : operatorList.get(i)) {
                    if (!(operatorFactory instanceof WindowOperatorFactory)) continue;
                    List outputColumnNames = ((WindowOperatorFactory)operatorFactory).getProcessor().getOutputColumnNames();
                    for (String columnName : outputColumnNames) {
                        int indexInRowSignature = rowSignature.indexOf(columnName);
                        if (indexInRowSignature != -1 && bob.build().indexOf(columnName) == -1) {
                            ColumnType columnType = (ColumnType)rowSignature.getColumnType(indexInRowSignature).get();
                            bob.add(columnName, columnType);
                            log.info("Added column [%s] of type [%s] to row signature for window stage.", new Object[]{columnName, columnType});
                            continue;
                        }
                        throw new ISE("Found unexpected column [%s] already present in row signature [%s].", new Object[]{columnName, rowSignature});
                    }
                }
                RowSignature intermediateSignature = bob.build();
                if (i + 1 == operatorList.size()) {
                    stageRowSignature = finalWindowStageRowSignature;
                    nextShuffleSpec = finalWindowStageShuffleSpec;
                } else {
                    nextShuffleSpec = this.findShuffleSpecForNextWindow(operatorList.get(i + 1), queryKitSpec.getNumPartitionsForShuffle());
                    stageRowSignature = nextShuffleSpec == null ? intermediateSignature : QueryKitUtils.sortableSignature(intermediateSignature, nextShuffleSpec.clusterBy().getColumns());
                }
                log.info("Using row signature [%s] for window stage.", new Object[]{stageRowSignature});
                boolean partitionOperatorExists = false;
                ArrayList<String> currentPartitionColumns = new ArrayList<String>();
                for (OperatorFactory of2 : operatorList.get(i)) {
                    if (!(of2 instanceof NaivePartitioningOperatorFactory)) continue;
                    for (String s : ((NaivePartitioningOperatorFactory)of2).getPartitionColumns()) {
                        currentPartitionColumns.add(s);
                        partitionOperatorExists = true;
                    }
                }
                if (partitionOperatorExists) {
                    partitionColumnNames = currentPartitionColumns;
                }
                log.info("Columns which would be used to define partitioning boundaries for this window stage are [%s]", new Object[]{partitionColumnNames});
                queryDefBuilder.add(StageDefinition.builder(firstStageNumber + i).inputs(new StageInputSpec(firstStageNumber + i - 1)).signature(stageRowSignature).maxWorkerCount(queryKitSpec.getMaxNonLeafWorkerCount()).shuffleSpec(nextShuffleSpec).processorFactory(new WindowOperatorQueryFrameProcessorFactory(queryToRun, operatorList.get(i), stageRowSignature, maxRowsMaterialized, partitionColumnNames)));
            }
        }
        return queryDefBuilder.build();
    }

    private List<List<OperatorFactory>> getOperatorListFromQuery(WindowOperatorQuery originalQuery) {
        ArrayList<List<OperatorFactory>> operatorList = new ArrayList<List<OperatorFactory>>();
        List operators = originalQuery.getOperators();
        ArrayList<OperatorFactory> currentStage = new ArrayList<OperatorFactory>();
        for (int i = 0; i < operators.size(); ++i) {
            OperatorFactory of = (OperatorFactory)operators.get(i);
            currentStage.add(of);
            if (!(of instanceof WindowOperatorFactory)) continue;
            while (i + 1 < operators.size() && operators.get(i + 1) instanceof WindowOperatorFactory) {
                currentStage.add((OperatorFactory)operators.get(++i));
            }
            operatorList.add(new ArrayList(currentStage));
            currentStage.clear();
        }
        if (!currentStage.isEmpty()) {
            throw new ISE("Found unexpected operators [%s] present in the list of operators [%s].", new Object[]{currentStage, operators});
        }
        return operatorList;
    }

    private ShuffleSpec findShuffleSpecForNextWindow(List<OperatorFactory> operatorFactories, int partitionCount) {
        NaivePartitioningOperatorFactory partition = null;
        NaiveSortOperatorFactory sort = null;
        for (OperatorFactory operatorFactory : operatorFactories) {
            if (operatorFactory instanceof NaivePartitioningOperatorFactory) {
                partition = (NaivePartitioningOperatorFactory)operatorFactory;
                continue;
            }
            if (!(operatorFactory instanceof NaiveSortOperatorFactory)) continue;
            sort = (NaiveSortOperatorFactory)operatorFactory;
        }
        HashMap<String, ColumnWithDirection.Direction> sortColumnsMap = new HashMap<String, ColumnWithDirection.Direction>();
        if (sort != null) {
            for (ColumnWithDirection sortColumn : sort.getSortColumns()) {
                sortColumnsMap.put(sortColumn.getColumn(), sortColumn.getDirection());
            }
        }
        if (partition == null) {
            return null;
        }
        if (partition.getPartitionColumns().isEmpty()) {
            return MixShuffleSpec.instance();
        }
        ArrayList<KeyColumn> arrayList = new ArrayList<KeyColumn>();
        for (String partitionColumn : partition.getPartitionColumns()) {
            KeyColumn kc = sortColumnsMap.get(partitionColumn) == ColumnWithDirection.Direction.DESC ? new KeyColumn(partitionColumn, KeyOrder.DESCENDING) : new KeyColumn(partitionColumn, KeyOrder.ASCENDING);
            arrayList.add(kc);
        }
        return new HashShuffleSpec(new ClusterBy(arrayList, 0), partitionCount);
    }

    private QueryDefinitionBuilder makeQueryDefinitionBuilder(String queryId, DataSourcePlan dataSourcePlan, ShuffleSpec shuffleSpec) {
        QueryDefinitionBuilder queryDefBuilder = QueryDefinition.builder(queryId);
        int previousStageNumber = dataSourcePlan.getSubQueryDefBuilder().get().build().getFinalStageDefinition().getStageNumber();
        for (StageDefinition stageDef : dataSourcePlan.getSubQueryDefBuilder().get().build().getStageDefinitions()) {
            if (stageDef.getStageNumber() == previousStageNumber) {
                RowSignature rowSignature = QueryKitUtils.sortableSignature(stageDef.getSignature(), shuffleSpec.clusterBy().getColumns());
                queryDefBuilder.add(StageDefinition.builder(stageDef).shuffleSpec(shuffleSpec).signature(rowSignature));
                continue;
            }
            queryDefBuilder.add(StageDefinition.builder(stageDef));
        }
        return queryDefBuilder;
    }

    private static ClusterBy computeClusterByForFinalWindowStage(Granularity segmentGranularity) {
        List<KeyColumn> clusterByColumns = Collections.singletonList(new KeyColumn("__boost", KeyOrder.ASCENDING));
        return QueryKitUtils.clusterByWithSegmentGranularity(new ClusterBy(clusterByColumns, 0), segmentGranularity);
    }

    private static RowSignature computeSignatureForFinalWindowStage(RowSignature rowSignature, ClusterBy finalWindowClusterBy, Granularity segmentGranularity) {
        RowSignature.Builder finalWindowStageRowSignatureBuilder = RowSignature.builder().addAll(rowSignature).add("__boost", ColumnType.LONG);
        return QueryKitUtils.sortableSignature(QueryKitUtils.signatureWithSegmentGranularity(finalWindowStageRowSignatureBuilder.build(), segmentGranularity), finalWindowClusterBy.getColumns());
    }
}

