/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;

public class QueryDefinition {
    private final Map<StageId, StageDefinition> stageDefinitions;
    private final StageId finalStage;

    private QueryDefinition(Map<StageId, StageDefinition> stageDefinitions, StageId finalStage) {
        this.stageDefinitions = stageDefinitions;
        this.finalStage = finalStage;
    }

    @JsonCreator
    static QueryDefinition create(@JsonProperty(value="stages") List<StageDefinition> stageDefinitions) {
        HashMap<StageId, StageDefinition> stageMap = new HashMap<StageId, StageDefinition>();
        HashSet<StageId> nonFinalStages = new HashSet<StageId>();
        IntOpenHashSet stageNumbers = new IntOpenHashSet();
        for (StageDefinition stage : stageDefinitions) {
            if (!stageNumbers.add(stage.getStageNumber())) {
                throw new ISE("Cannot accept duplicate stage numbers", new Object[0]);
            }
            stageMap.put(stage.getId(), stage);
            IntIterator intIterator = stage.getInputStageNumbers().iterator();
            while (intIterator.hasNext()) {
                int stageNumber = (Integer)intIterator.next();
                nonFinalStages.add(new StageId(stage.getId().getQueryId(), stageNumber));
            }
        }
        for (StageId nonFinalStageId : nonFinalStages) {
            if (stageMap.containsKey(nonFinalStageId)) continue;
            throw new ISE("Stage [%s] is missing a definition", new Object[]{nonFinalStageId});
        }
        int finalStageCandidates = stageMap.size() - nonFinalStages.size();
        if (finalStageCandidates == 1) {
            return new QueryDefinition(stageMap, (StageId)Iterables.getOnlyElement((Iterable)Sets.difference(stageMap.keySet(), nonFinalStages)));
        }
        throw new IAE("Must have a single final stage, but found [%d] candidates", new Object[]{finalStageCandidates});
    }

    public static QueryDefinitionBuilder builder(String queryId) {
        return new QueryDefinitionBuilder(queryId);
    }

    public static QueryDefinitionBuilder builder(QueryDefinition queryDef) {
        return new QueryDefinitionBuilder(queryDef.getQueryId()).addAll(queryDef);
    }

    public String getQueryId() {
        return this.finalStage.getQueryId();
    }

    public StageDefinition getFinalStageDefinition() {
        return this.getStageDefinition(this.finalStage);
    }

    @JsonProperty(value="stages")
    public List<StageDefinition> getStageDefinitions() {
        return ImmutableList.copyOf(this.stageDefinitions.values());
    }

    public StageDefinition getStageDefinition(int stageNumber) {
        return this.getStageDefinition(new StageId(this.getQueryId(), stageNumber));
    }

    public StageDefinition getStageDefinition(StageId stageId) {
        return (StageDefinition)Preconditions.checkNotNull((Object)this.stageDefinitions.get(stageId), (String)"No stageId [%s]", (Object)stageId);
    }

    public int getNextStageNumber() {
        return this.stageDefinitions.values().stream().mapToInt(StageDefinition::getStageNumber).max().orElse(-1) + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDefinition that = (QueryDefinition)o;
        return Objects.equals(this.stageDefinitions, that.stageDefinitions) && Objects.equals(this.finalStage, that.finalStage);
    }

    public int hashCode() {
        return Objects.hash(this.stageDefinitions, this.finalStage);
    }

    public String toString() {
        return "QueryDefinition{stageDefinitions=" + this.stageDefinitions + '}';
    }
}

