/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;

@JsonTypeName(value="segments")
public class SegmentsInputSlice
implements InputSlice {
    private final String dataSource;
    private final List<RichSegmentDescriptor> descriptors;
    private final List<DataServerRequestDescriptor> servedSegments;

    @JsonCreator
    public SegmentsInputSlice(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<RichSegmentDescriptor> descriptors, @JsonProperty(value="servedSegments") @Nullable List<DataServerRequestDescriptor> servedSegments) {
        this.dataSource = dataSource;
        this.descriptors = descriptors;
        this.servedSegments = servedSegments;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="segments")
    public List<RichSegmentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Nullable
    @JsonProperty(value="servedSegments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<DataServerRequestDescriptor> getServedSegments() {
        return this.servedSegments;
    }

    @Override
    public int fileCount() {
        return this.descriptors.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsInputSlice that = (SegmentsInputSlice)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.descriptors, that.descriptors) && Objects.equals(this.servedSegments, that.servedSegments);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.descriptors, this.servedSegments);
    }

    public String toString() {
        return "SegmentsInputSlice{dataSource='" + this.dataSource + '\'' + ", descriptors=" + this.descriptors + ", servedSegments=" + this.servedSegments + '}';
    }
}

