/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.processor;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.Rows;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.SegmentGenerationProgressCounter;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.sql.calcite.planner.ColumnMapping;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;

public class SegmentGeneratorFrameProcessor
implements FrameProcessor<DataSegment> {
    private static final Logger log = new Logger(SegmentGeneratorFrameProcessor.class);
    private final ReadableFrameChannel inChannel;
    private final FrameReader frameReader;
    private final Appenderator appenderator;
    private final SegmentIdWithShardSpec segmentIdWithShardSpec;
    private final List<String> dimensionsForInputRows;
    private final Object2IntMap<String> outputColumnNameToFrameColumnNumberMap;
    private final SegmentGenerationProgressCounter segmentGenerationProgressCounter;
    private boolean firstRun = true;
    private long rowsWritten = 0L;

    SegmentGeneratorFrameProcessor(ReadableInput readableInput, ColumnMappings columnMappings, List<String> dimensionsForInputRows, Appenderator appenderator, SegmentIdWithShardSpec segmentIdWithShardSpec, SegmentGenerationProgressCounter segmentGenerationProgressCounter) {
        this.inChannel = readableInput.getChannel();
        this.frameReader = readableInput.getChannelFrameReader();
        this.appenderator = appenderator;
        this.segmentIdWithShardSpec = segmentIdWithShardSpec;
        this.dimensionsForInputRows = dimensionsForInputRows;
        this.segmentGenerationProgressCounter = segmentGenerationProgressCounter;
        this.outputColumnNameToFrameColumnNumberMap = new Object2IntOpenHashMap();
        this.outputColumnNameToFrameColumnNumberMap.defaultReturnValue(-1);
        for (ColumnMapping columnMapping : columnMappings.getMappings()) {
            this.outputColumnNameToFrameColumnNumberMap.put((Object)columnMapping.getOutputColumn(), this.frameReader.signature().indexOf(columnMapping.getQueryColumn()));
        }
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    public ReturnOrAwait<DataSegment> runIncrementally(IntSet readableInputs) throws InterruptedException {
        if (this.firstRun) {
            log.debug("Starting job for segment [%s].", new Object[]{this.segmentIdWithShardSpec.asSegmentId()});
            this.appenderator.startJob();
            this.firstRun = false;
        }
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAll((int)1);
        }
        if (this.inChannel.isFinished()) {
            SegmentsAndCommitMetadata metadata;
            if (this.rowsWritten == 0L) {
                log.debug("Finished reading. No data for segment [%s], skipping.", new Object[]{this.segmentIdWithShardSpec.asSegmentId()});
                return ReturnOrAwait.returnObject(null);
            }
            log.debug("Finished reading. Pushing segment [%s].", new Object[]{this.segmentIdWithShardSpec.asSegmentId()});
            ListenableFuture pushFuture = this.appenderator.push(Collections.singletonList(this.segmentIdWithShardSpec), null, false);
            try {
                metadata = (SegmentsAndCommitMetadata)FutureUtils.get((ListenableFuture)pushFuture, (boolean)true);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            this.appenderator.clear();
            log.debug("Finished work for segment [%s].", new Object[]{this.segmentIdWithShardSpec.asSegmentId()});
            return ReturnOrAwait.returnObject((Object)((DataSegment)Iterables.getOnlyElement((Iterable)metadata.getSegments())));
        }
        if (this.appenderator.getSegments().isEmpty()) {
            log.debug("Received first frame for segment [%s].", new Object[]{this.segmentIdWithShardSpec.asSegmentId()});
        }
        this.addFrame(this.inChannel.read());
        return ReturnOrAwait.awaitAll((int)1);
    }

    public void cleanup() throws IOException {
        Closeable[] closeableArray = new Closeable[1];
        closeableArray[0] = () -> ((Appenderator)this.appenderator).close();
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])closeableArray);
    }

    private void addFrame(Frame frame) {
        RowSignature signature = this.frameReader.signature();
        MSQInputRow inputRow = new MSQInputRow();
        CursorFactory cursorFactory = this.frameReader.makeCursorFactory(frame);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            if (cursor == null) {
                return;
            }
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            List selectors = this.frameReader.signature().getColumnNames().stream().map(arg_0 -> ((ColumnSelectorFactory)columnSelectorFactory).makeColumnValueSelector(arg_0)).collect(Collectors.toList());
            while (!cursor.isDone()) {
                for (int j = 0; j < signature.size(); ++j) {
                    ((MSQInputRow)inputRow).getBackingArray()[j] = ((BaseObjectColumnValueSelector)selectors.get(j)).getObject();
                }
                try {
                    ++this.rowsWritten;
                    this.appenderator.add(this.segmentIdWithShardSpec, (InputRow)inputRow, null);
                    this.segmentGenerationProgressCounter.incrementRowsProcessed(1L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                cursor.advance();
            }
        }
    }

    private class MSQInputRow
    implements InputRow {
        private final Object[] backingArray;
        private final int timeColumnNumber;

        public MSQInputRow() {
            this.timeColumnNumber = SegmentGeneratorFrameProcessor.this.outputColumnNameToFrameColumnNumberMap.getInt((Object)"__time");
            this.backingArray = new Object[SegmentGeneratorFrameProcessor.this.frameReader.signature().size()];
        }

        public long getTimestampFromEpoch() {
            if (this.timeColumnNumber < 0) {
                return 0L;
            }
            return MSQTasks.primaryTimestampFromObjectForInsert(this.backingArray[this.timeColumnNumber]);
        }

        public DateTime getTimestamp() {
            return DateTimes.utc((long)this.getTimestampFromEpoch());
        }

        public List<String> getDimensions() {
            return SegmentGeneratorFrameProcessor.this.dimensionsForInputRows;
        }

        @Nullable
        public Object getRaw(String columnName) {
            int columnNumber = SegmentGeneratorFrameProcessor.this.outputColumnNameToFrameColumnNumberMap.getInt((Object)columnName);
            if (columnNumber < 0) {
                return null;
            }
            return this.backingArray[columnNumber];
        }

        public List<String> getDimension(String columnName) {
            return Rows.objectToStrings((Object)this.getRaw(columnName));
        }

        @Nullable
        public Number getMetric(String columnName) {
            return Rows.objectToNumber((String)columnName, (Object)this.getRaw(columnName), (boolean)true);
        }

        public int compareTo(Row other) {
            throw new UnsupportedOperationException();
        }

        private Object[] getBackingArray() {
            return this.backingArray;
        }

        public String toString() {
            return "MSQInputRow{backingArray=" + Arrays.toString(this.backingArray) + ", timeColumnNumber=" + this.timeColumnNumber + '}';
        }
    }
}

