/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQWarningReportPublisher;

public class MSQWarningReportSimplePublisher
implements MSQWarningReportPublisher {
    final String workerId;
    final ControllerClient controllerClient;
    final String taskId;
    @Nullable
    final String host;

    public MSQWarningReportSimplePublisher(String workerId, ControllerClient controllerClient, String taskId, @Nullable String host) {
        this.workerId = workerId;
        this.controllerClient = controllerClient;
        this.taskId = taskId;
        this.host = host;
    }

    @Override
    public void publishException(int stageNumber, Throwable e) {
        MSQErrorReport warningReport = MSQErrorReport.fromException(this.taskId, this.host, stageNumber, e);
        try {
            this.controllerClient.postWorkerWarning((List<MSQErrorReport>)ImmutableList.of((Object)warningReport));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void close() {
    }
}

