/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.sql.calcite.planner.ColumnMappings;

public class MSQSpec {
    private final Query<?> query;
    private final ColumnMappings columnMappings;
    private final MSQDestination destination;
    private final WorkerAssignmentStrategy assignmentStrategy;
    private final MSQTuningConfig tuningConfig;

    @JsonCreator
    public MSQSpec(@JsonProperty(value="query") Query<?> query, @JsonProperty(value="columnMappings") ColumnMappings columnMappings, @JsonProperty(value="destination") MSQDestination destination, @JsonProperty(value="assignmentStrategy") WorkerAssignmentStrategy assignmentStrategy, @JsonProperty(value="tuningConfig") MSQTuningConfig tuningConfig) {
        this.query = (Query)Preconditions.checkNotNull(query, (Object)"query");
        this.columnMappings = (ColumnMappings)Preconditions.checkNotNull((Object)columnMappings, (Object)"columnMappings");
        this.destination = (MSQDestination)Preconditions.checkNotNull((Object)destination, (Object)"destination");
        this.assignmentStrategy = (WorkerAssignmentStrategy)((Object)Preconditions.checkNotNull((Object)((Object)assignmentStrategy), (Object)"assignmentStrategy"));
        this.tuningConfig = (MSQTuningConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty
    public Query<?> getQuery() {
        return this.query;
    }

    @JsonProperty(value="columnMappings")
    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    @JsonProperty
    public MSQDestination getDestination() {
        return this.destination;
    }

    @JsonProperty
    public WorkerAssignmentStrategy getAssignmentStrategy() {
        return this.assignmentStrategy;
    }

    @JsonProperty
    public MSQTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public MSQSpec withOverriddenContext(Map<String, Object> contextOverride) {
        if (contextOverride == null || contextOverride.isEmpty()) {
            return this;
        }
        return new MSQSpec(this.query.withOverriddenContext(contextOverride), this.columnMappings, this.destination, this.assignmentStrategy, this.tuningConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQSpec that = (MSQSpec)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.columnMappings, that.columnMappings) && Objects.equals(this.destination, that.destination) && Objects.equals((Object)this.assignmentStrategy, (Object)that.assignmentStrategy) && Objects.equals(this.tuningConfig, that.tuningConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.columnMappings, this.destination, this.assignmentStrategy, this.tuningConfig});
    }

    public static class Builder {
        private Query<?> query;
        private ColumnMappings columnMappings;
        private MSQDestination destination = TaskReportMSQDestination.instance();
        private WorkerAssignmentStrategy assignmentStrategy = WorkerAssignmentStrategy.MAX;
        private MSQTuningConfig tuningConfig;

        public Builder query(Query<?> query) {
            this.query = query;
            return this;
        }

        public Builder columnMappings(ColumnMappings columnMappings) {
            this.columnMappings = columnMappings;
            return this;
        }

        public Builder destination(MSQDestination destination) {
            this.destination = destination;
            return this;
        }

        public Builder assignmentStrategy(WorkerAssignmentStrategy assignmentStrategy) {
            this.assignmentStrategy = assignmentStrategy;
            return this;
        }

        public Builder tuningConfig(MSQTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public MSQSpec build() {
            if (this.destination == null) {
                this.destination = TaskReportMSQDestination.instance();
            }
            return new MSQSpec(this.query, this.columnMappings, this.destination, this.assignmentStrategy, this.tuningConfig);
        }
    }
}

