/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.indexer.TaskState;

public class WorkerStats {
    private final String workerId;
    private final TaskState state;
    private final long durationMs;
    private final long pendingMs;

    @JsonCreator
    public WorkerStats(@JsonProperty(value="workerId") String workerId, @JsonProperty(value="state") TaskState state, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="pendingMs") long pendingMs) {
        this.workerId = workerId;
        this.state = state;
        this.durationMs = durationMs;
        this.pendingMs = pendingMs;
    }

    @JsonProperty
    public String getWorkerId() {
        return this.workerId;
    }

    @JsonProperty
    public TaskState getState() {
        return this.state;
    }

    @JsonProperty(value="durationMs")
    public long getDuration() {
        return this.durationMs;
    }

    @JsonProperty(value="pendingMs")
    public long getPendingTimeInMs() {
        return this.pendingMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerStats that = (WorkerStats)o;
        return this.durationMs == that.durationMs && this.pendingMs == that.pendingMs && Objects.equals(this.workerId, that.workerId) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(this.workerId, this.state, this.durationMs, this.pendingMs);
    }

    public String toString() {
        return "WorkerStats{workerId='" + this.workerId + '\'' + ", state=" + this.state + ", durationMs=" + this.durationMs + ", pendingMs=" + this.pendingMs + '}';
    }
}

