/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling.ec2;

import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class EC2IamProfileData {
    private final String name;
    private final String arn;

    @JsonCreator
    public EC2IamProfileData(@JsonProperty(value="name") String name, @JsonProperty(value="arn") String arn) {
        this.name = name;
        this.arn = arn;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getArn() {
        return this.arn;
    }

    public IamInstanceProfileSpecification toIamInstanceProfileSpecification() {
        IamInstanceProfileSpecification spec = new IamInstanceProfileSpecification();
        spec.setName(this.name);
        spec.setArn(this.arn);
        return spec;
    }

    public String toString() {
        return "EC2IamProfileData{name='" + this.name + '\'' + ", arn='" + this.arn + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EC2IamProfileData that = (EC2IamProfileData)o;
        if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.arn != null ? this.arn.hashCode() : 0);
        return result;
    }
}

