/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.HashPartitioner;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class HashBucketShardSpec
implements BucketNumberedShardSpec<BuildingHashBasedNumberedShardSpec> {
    private final int bucketId;
    private final int numBuckets;
    private final List<String> partitionDimensions;
    private final HashPartitionFunction partitionFunction;
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public HashBucketShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="partitionDimensions") List<String> partitionDimensions, @JsonProperty(value="partitionFunction") HashPartitionFunction partitionFunction, @JacksonInject ObjectMapper jsonMapper) {
        this.bucketId = bucketId;
        this.numBuckets = numBuckets;
        this.partitionDimensions = partitionDimensions == null ? HashBasedNumberedShardSpec.DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
        this.partitionFunction = (HashPartitionFunction)((Object)Preconditions.checkNotNull((Object)((Object)partitionFunction), (Object)"partitionFunction"));
        this.jsonMapper = jsonMapper;
    }

    @Override
    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @JsonProperty
    public HashPartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    @Override
    public BuildingHashBasedNumberedShardSpec convert(int partitionId) {
        return new BuildingHashBasedNumberedShardSpec(partitionId, this.bucketId, this.numBuckets, this.partitionDimensions, this.partitionFunction, this.jsonMapper);
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return new HashPartitioner(this.jsonMapper, this.partitionFunction, this.partitionDimensions, this.numBuckets).createHashLookup(shardSpecs);
    }

    @Override
    public String getType() {
        return "bucket_hash";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashBucketShardSpec that = (HashBucketShardSpec)o;
        return this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimensions, that.partitionDimensions) && this.partitionFunction == that.partitionFunction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucketId, this.numBuckets, this.partitionDimensions, this.partitionFunction});
    }

    public String toString() {
        return "HashBucketShardSpec{bucketId=" + this.bucketId + ", numBuckets=" + this.numBuckets + ", partitionDimensions=" + this.partitionDimensions + ", partitionFunction=" + (Object)((Object)this.partitionFunction) + '}';
    }
}

