/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.transform.RowFunction;
import org.joda.time.DateTime;

public class TransformedInputRow
implements InputRow {
    private final InputRow row;
    private final Map<String, RowFunction> transforms;
    private final DateTime timestamp;

    public TransformedInputRow(InputRow row, Map<String, RowFunction> transforms) {
        this.row = row;
        this.transforms = transforms;
        this.timestamp = TransformedInputRow.readTimestampFromRow(row, transforms);
    }

    @Override
    public List<String> getDimensions() {
        return this.row.getDimensions();
    }

    static DateTime readTimestampFromRow(InputRow row, Map<String, RowFunction> transforms) {
        long ts;
        RowFunction transform = transforms.get("__time");
        if (transform != null) {
            Number transformedVal = Rows.objectToNumber("__time", transform.eval(row), true);
            if (transformedVal == null) {
                throw new ParseException(row.toString(), "Could not transform value for __time.", new Object[0]);
            }
            ts = transformedVal.longValue();
        } else {
            ts = row.getTimestampFromEpoch();
        }
        return DateTimes.utc(ts);
    }

    @Override
    public long getTimestampFromEpoch() {
        return this.timestamp.getMillis();
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<String> getDimension(String dimension) {
        RowFunction transform = this.transforms.get(dimension);
        if (transform != null) {
            return transform.evalDimension(this.row);
        }
        return this.row.getDimension(dimension);
    }

    @Override
    public Object getRaw(String column) {
        RowFunction transform = this.transforms.get(column);
        if (transform != null) {
            return transform.eval(this.row);
        }
        return this.row.getRaw(column);
    }

    @Override
    public Number getMetric(String metric) {
        RowFunction transform = this.transforms.get(metric);
        if (transform != null) {
            return Rows.objectToNumber(metric, transform.eval(this.row), true);
        }
        return this.row.getMetric(metric);
    }

    public InputRow getBaseRow() {
        return this.row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformedInputRow that = (TransformedInputRow)o;
        return Objects.equals(this.row, that.row) && Objects.equals(this.transforms, that.transforms);
    }

    public int hashCode() {
        return Objects.hash(this.row, this.transforms);
    }

    @Override
    public int compareTo(Row o) {
        return this.row.compareTo(o);
    }

    public String toString() {
        return "TransformedInputRow{row=" + this.row + '}';
    }
}

