/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.join.table.IndexedTable;

public class IndexedTableColumnValueSelector
implements ColumnValueSelector<Object> {
    private final IntSupplier currentRow;
    private final IndexedTable.Reader columnReader;

    IndexedTableColumnValueSelector(IndexedTable table, IntSupplier currentRow, int columnNumber, Closer closer) {
        this.currentRow = currentRow;
        this.columnReader = table.columnReader(columnNumber);
        closer.register(this.columnReader);
    }

    @Override
    public double getDouble() {
        Object value;
        int rowNum = this.currentRow.getAsInt();
        if (rowNum != -1 && (value = this.columnReader.read(this.currentRow.getAsInt())) instanceof Number) {
            return ((Number)value).doubleValue();
        }
        assert (NullHandling.replaceWithDefault());
        return NullHandling.defaultDoubleValue();
    }

    @Override
    public float getFloat() {
        Object value;
        int rowNum = this.currentRow.getAsInt();
        if (rowNum != -1 && (value = this.columnReader.read(this.currentRow.getAsInt())) instanceof Number) {
            return ((Number)value).floatValue();
        }
        assert (NullHandling.replaceWithDefault());
        return NullHandling.defaultFloatValue().floatValue();
    }

    @Override
    public long getLong() {
        Object value;
        int rowNum = this.currentRow.getAsInt();
        if (rowNum != -1 && (value = this.columnReader.read(this.currentRow.getAsInt())) instanceof Number) {
            return ((Number)value).longValue();
        }
        assert (NullHandling.replaceWithDefault());
        return NullHandling.defaultLongValue();
    }

    @Override
    public boolean isNull() {
        int rowNum = this.currentRow.getAsInt();
        if (rowNum == -1) {
            return true;
        }
        Object value = this.columnReader.read(rowNum);
        return !(value instanceof Number);
    }

    @Override
    @Nullable
    public Object getObject() {
        int rowNum = this.currentRow.getAsInt();
        if (rowNum == -1) {
            return null;
        }
        return this.columnReader.read(this.currentRow.getAsInt());
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("columnReader", this.columnReader);
        inspector.visit("currentRow", this.currentRow);
    }
}

