/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import java.util.List;
import java.util.TreeMap;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;

public class EnumeratedTreeDistribution<T>
extends EnumeratedDistribution {
    private TreeMap<Double, Integer> probabilityRanges = new TreeMap();
    private List<Pair<T, Double>> normalizedPmf = this.getPmf();

    public EnumeratedTreeDistribution(List<Pair<T, Double>> pmf) {
        super(pmf);
        double cumulativep = 0.0;
        for (int i = 0; i < this.normalizedPmf.size(); ++i) {
            this.probabilityRanges.put(cumulativep, i);
            Pair<T, Double> pair = this.normalizedPmf.get(i);
            cumulativep += ((Double)pair.getSecond()).doubleValue();
        }
    }

    public T sample() {
        double randomValue = this.random.nextDouble();
        Integer valueIndex = this.probabilityRanges.floorEntry(randomValue).getValue();
        return (T)this.normalizedPmf.get(valueIndex).getFirst();
    }
}

