/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.filter.DimensionPredicateFilter;

public class SearchQueryFilter
extends DimensionPredicateFilter {
    private final SearchQuerySpec query;

    @JsonCreator
    public SearchQueryFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="query") SearchQuerySpec query, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @JsonProperty(value="filterTuning") FilterTuning filterTuning) {
        super(dimension, new SearchQueryDruidPredicateFactory(query), extractionFn, filterTuning);
        this.query = query;
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.dimension);
        }
        return new SearchQueryFilter(rewriteDimensionTo, this.query, this.extractionFn, this.filterTuning);
    }

    @Override
    public String toString() {
        return "SearchFilter{query='" + this.query + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchQueryFilter that = (SearchQueryFilter)o;
        return Objects.equals(this.query, that.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query);
    }

    @VisibleForTesting
    static class SearchQueryDruidPredicateFactory
    implements DruidPredicateFactory {
        private final SearchQuerySpec query;

        SearchQueryDruidPredicateFactory(SearchQuerySpec query) {
            this.query = query;
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return input -> input == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.of(this.query.accept((String)input));
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return input -> DruidPredicateMatch.of(this.query.accept(String.valueOf(input)));
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return input -> DruidPredicateMatch.of(this.query.accept(String.valueOf(input)));
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return input -> DruidPredicateMatch.of(this.query.accept(String.valueOf(input)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchQueryDruidPredicateFactory that = (SearchQueryDruidPredicateFactory)o;
            return Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.query);
        }
    }
}

