/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorObjectSelector;

public interface ComplexColumn
extends BaseColumn {
    public Class<?> getClazz();

    public String getTypeName();

    @Nullable
    public Object getRowValue(int var1);

    public int getLength();

    @Override
    public void close();

    @Override
    default public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        return new ObjectColumnSelector(){

            @Override
            @Nullable
            public Object getObject() {
                return ComplexColumn.this.getRowValue(offset.getOffset());
            }

            @Override
            public Class classOfObject() {
                return ComplexColumn.this.getClazz();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", ComplexColumn.this);
            }
        };
    }

    @Override
    default public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        return new VectorObjectSelector(){
            final Object[] vector;
            private int id;
            {
                this.vector = new Object[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public Object[] getObjectVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    int startOffset = offset.getStartOffset();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = ComplexColumn.this.getRowValue(startOffset + i);
                    }
                } else {
                    int[] offsets = offset.getOffsets();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = ComplexColumn.this.getRowValue(offsets[i]);
                    }
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        };
    }
}

