/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.TopNAlgorithmSelector;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;

public class TopNQuery
extends BaseQuery<Result<TopNResultValue>> {
    public static final String TOPN = "topN";
    private final VirtualColumns virtualColumns;
    private final DimensionSpec dimensionSpec;
    private final TopNMetricSpec topNMetricSpec;
    private final int threshold;
    private final DimFilter dimFilter;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;

    @JsonCreator
    public TopNQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="dimension") DimensionSpec dimensionSpec, @JsonProperty(value="metric") TopNMetricSpec topNMetricSpec, @JsonProperty(value="threshold") int threshold, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context, granularity);
        Preconditions.checkNotNull((Object)dimensionSpec, (Object)"dimensionSpec can't be null");
        Preconditions.checkNotNull((Object)topNMetricSpec, (Object)"must specify a metric");
        Preconditions.checkArgument((threshold != 0 ? 1 : 0) != 0, (Object)"Threshold cannot be equal to 0.");
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimensionSpec = dimensionSpec;
        this.topNMetricSpec = topNMetricSpec;
        this.threshold = threshold;
        this.dimFilter = dimFilter;
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = Queries.prepareAggregations((List<String>)ImmutableList.of((Object)dimensionSpec.getOutputName()), this.aggregatorSpecs, (List<PostAggregator>)(postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs));
        topNMetricSpec.verifyPreconditions(this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return TOPN;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=VirtualColumns.JsonIncludeFilter.class)
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty(value="dimension")
    public DimensionSpec getDimensionSpec() {
        return this.dimensionSpec;
    }

    @JsonProperty(value="metric")
    public TopNMetricSpec getTopNMetricSpec() {
        return this.topNMetricSpec;
    }

    @JsonProperty(value="threshold")
    public int getThreshold() {
        return this.threshold;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @Override
    @Nullable
    public Set<String> getRequiredColumns() {
        return Queries.computeRequiredColumns(this.virtualColumns, this.dimFilter, Collections.singletonList(this.dimensionSpec.getDimension()), this.aggregatorSpecs);
    }

    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        if (this.dimensionSpec.getExtractionFn() != null) {
            selector.setHasExtractionFn(true);
        }
        this.topNMetricSpec.initTopNAlgorithmSelector(selector);
    }

    public RowSignature getResultSignature(RowSignature.Finalization finalization) {
        return RowSignature.builder().addTimeColumn().addDimensions(Collections.singletonList(this.getDimensionSpec())).addAggregators(this.getAggregatorSpecs(), finalization).addPostAggregators(this.getPostAggregatorSpecs()).build();
    }

    public TopNQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return new TopNQueryBuilder(this).intervals(querySegmentSpec).build();
    }

    public TopNQuery withDimensionSpec(DimensionSpec spec) {
        return new TopNQueryBuilder(this).dimension(spec).build();
    }

    public TopNQuery withAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
        return new TopNQueryBuilder(this).aggregators(aggregatorSpecs).build();
    }

    public TopNQuery withPostAggregatorSpecs(List<PostAggregator> postAggs) {
        return new TopNQueryBuilder(this).postAggregators(postAggs).build();
    }

    @Override
    public Query<Result<TopNResultValue>> withDataSource(DataSource dataSource) {
        return new TopNQueryBuilder(this).dataSource(dataSource).build();
    }

    @Override
    public Query<Result<TopNResultValue>> optimizeForSegment(PerSegmentQueryOptimizationContext optimizationContext) {
        return new TopNQueryBuilder(this).aggregators(this.optimizeAggs(optimizationContext)).build();
    }

    public TopNQuery withThreshold(int threshold) {
        return new TopNQueryBuilder(this).threshold(threshold).build();
    }

    public TopNQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return new TopNQueryBuilder(this).context(TopNQuery.computeOverriddenContext(this.getContext(), contextOverrides)).build();
    }

    public String toString() {
        return "TopNQuery{dataSource='" + this.getDataSource() + '\'' + ", dimensionSpec=" + this.dimensionSpec + ", topNMetricSpec=" + this.topNMetricSpec + ", threshold=" + this.threshold + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.virtualColumns + ", dimFilter=" + this.dimFilter + ", granularity='" + this.getGranularity() + '\'' + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopNQuery topNQuery = (TopNQuery)o;
        return this.threshold == topNQuery.threshold && Objects.equals(this.virtualColumns, topNQuery.virtualColumns) && Objects.equals(this.dimensionSpec, topNQuery.dimensionSpec) && Objects.equals(this.topNMetricSpec, topNQuery.topNMetricSpec) && Objects.equals(this.dimFilter, topNQuery.dimFilter) && Objects.equals(this.aggregatorSpecs, topNQuery.aggregatorSpecs) && Objects.equals(this.postAggregatorSpecs, topNQuery.postAggregatorSpecs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.dimensionSpec, this.topNMetricSpec, this.threshold, this.dimFilter, this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    private List<AggregatorFactory> optimizeAggs(PerSegmentQueryOptimizationContext optimizationContext) {
        ArrayList<AggregatorFactory> optimizedAggs = new ArrayList<AggregatorFactory>();
        for (AggregatorFactory aggregatorFactory : this.aggregatorSpecs) {
            optimizedAggs.add(aggregatorFactory.optimizeForSegment(optimizationContext));
        }
        return optimizedAggs;
    }
}

