/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.query.search.SearchQuerySpec;

public class FragmentSearchQuerySpec
implements SearchQuerySpec {
    private static final byte CACHE_TYPE_ID = 2;
    private final List<String> values;
    private final boolean caseSensitive;
    private final String[] target;

    public FragmentSearchQuerySpec(List<String> values) {
        this(values, false);
    }

    @JsonCreator
    public FragmentSearchQuerySpec(@JsonProperty(value="values") List<String> values, @JsonProperty(value="caseSensitive") boolean caseSensitive) {
        this.values = values;
        this.caseSensitive = caseSensitive;
        TreeSet<String> set = new TreeSet<String>();
        if (values != null) {
            set.addAll(values);
        }
        this.target = set.toArray(new String[0]);
    }

    @JsonProperty
    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean accept(@Nullable String dimVal) {
        if (dimVal == null || this.values == null) {
            return false;
        }
        if (this.caseSensitive) {
            return this.containsAny(this.target, dimVal);
        }
        for (String search : this.target) {
            if (StringUtils.containsIgnoreCase((String)dimVal, (String)search)) continue;
            return false;
        }
        return true;
    }

    private boolean containsAny(String[] target, String input) {
        for (String value : target) {
            if (input.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] getCacheKey() {
        if (this.values == null) {
            return ByteBuffer.allocate(2).put((byte)2).put(this.caseSensitive ? (byte)1 : 0).array();
        }
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = org.apache.druid.java.util.common.StringUtils.toUtf8(value);
            valuesBytesSize += valuesBytes[index].length;
            ++index;
        }
        ByteBuffer queryCacheKey = ByteBuffer.allocate(2 + valuesBytesSize).put((byte)2).put(this.caseSensitive ? (byte)1 : 0);
        for (byte[] bytes : valuesBytes) {
            queryCacheKey.put(bytes);
        }
        return queryCacheKey.array();
    }

    public String toString() {
        return "FragmentSearchQuerySpec{values=" + this.values + ", caseSensitive=" + this.caseSensitive + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentSearchQuerySpec that = (FragmentSearchQuerySpec)o;
        if (this.caseSensitive ^ that.caseSensitive) {
            return false;
        }
        if (this.values == null && that.values == null) {
            return true;
        }
        return this.values != null && Arrays.equals(this.target, that.target);
    }

    public int hashCode() {
        return Arrays.hashCode(this.target) + (this.caseSensitive ? 1 : 0);
    }
}

