/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ColumnWithDirection {
    private final String columnName;
    private final Direction direction;

    public static ColumnWithDirection ascending(String column) {
        return new ColumnWithDirection(column, Direction.ASC);
    }

    public static ColumnWithDirection descending(String column) {
        return new ColumnWithDirection(column, Direction.DESC);
    }

    @JsonCreator
    public ColumnWithDirection(@JsonProperty(value="column") String columnName, @JsonProperty(value="direction") Direction direction) {
        this.columnName = columnName;
        this.direction = direction;
    }

    @JsonProperty(value="column")
    public String getColumn() {
        return this.columnName;
    }

    @JsonProperty(value="direction")
    public Direction getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnWithDirection)) {
            return false;
        }
        ColumnWithDirection that = (ColumnWithDirection)o;
        return Objects.equals(this.columnName, that.columnName) && this.direction == that.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.direction});
    }

    public String toString() {
        return "ColumnWithDirection{columnName='" + this.columnName + '\'' + ", direction=" + (Object)((Object)this.direction) + '}';
    }

    public static enum Direction {
        ASC(1),
        DESC(-1);

        private final int directionInt;

        private Direction(int directionInt) {
            this.directionInt = directionInt;
        }

        public int getDirectionInt() {
            return this.directionInt;
        }
    }
}

