/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;

public class MatchingDimExtractionFn
extends DimExtractionFn {
    private final String expr;
    private final Pattern pattern;

    @JsonCreator
    public MatchingDimExtractionFn(@JsonProperty(value="expr") String expr) {
        Preconditions.checkNotNull((Object)expr, (Object)"expr must not be null");
        this.expr = expr;
        this.pattern = Pattern.compile(expr);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] exprBytes = StringUtils.toUtf8(this.expr);
        return ByteBuffer.allocate(1 + exprBytes.length).put((byte)2).put(exprBytes).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable String dimValue) {
        if (NullHandling.isNullOrEquivalent(dimValue)) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(dimValue);
        return matcher.find() ? dimValue : null;
    }

    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return StringUtils.format("regex_matches(%s)", this.expr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchingDimExtractionFn that = (MatchingDimExtractionFn)o;
        return this.expr.equals(that.expr);
    }

    public int hashCode() {
        return this.expr.hashCode();
    }
}

