/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.NamedFunction;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;

public class NestedDataExpressions {
    private static ExpressionType JSON_ARRAY = ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA);

    @Nullable
    static Object unwrap(ExprEval input) {
        return NestedDataExpressions.unwrap(input.value());
    }

    static Object unwrap(Object input) {
        if (input instanceof Object[]) {
            return Arrays.stream((Object[])input).map(NestedDataExpressions::unwrap).toArray();
        }
        return StructuredData.unwrap(input);
    }

    static List<NestedPathPart> getJsonPathPartsFromLiteral(NamedFunction fn, Expr arg) {
        if (!arg.isLiteral() || !(arg.getLiteralValue() instanceof String)) {
            throw fn.validationFailed("second argument [%s] must be a literal [%s] value", arg.stringify(), ExpressionType.STRING);
        }
        List<NestedPathPart> parts = NestedPathFinder.parseJsonPath((String)arg.getLiteralValue());
        return parts;
    }

    public static class JsonKeysExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_keys";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final List<NestedPathPart> parts = NestedDataExpressions.getJsonPathPartsFromLiteral(this, args.get(1));
            final class JsonKeysExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public JsonKeysExpr(List<Expr> args) {
                    super(this$0, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    return ExprEval.ofType(ExpressionType.STRING_ARRAY, NestedPathFinder.findKeys(NestedDataExpressions.unwrap(input), parts));
                }

                @Override
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.STRING_ARRAY;
                }
            }
            return new JsonKeysExpr(args);
        }
    }

    public static class JsonPathsExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_paths";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final StructuredDataProcessor processor = new StructuredDataProcessor(){

                @Override
                public StructuredDataProcessor.ProcessedValue<?> processField(ArrayList<NestedPathPart> fieldPath, @Nullable Object fieldValue) {
                    return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                }

                @Override
                @Nullable
                public StructuredDataProcessor.ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> fieldPath, @Nullable List<?> array) {
                    ExprEval eval = ExprEval.bestEffortArray(array);
                    if (eval.type().isPrimitiveArray()) {
                        return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                    }
                    return null;
                }
            };
            final class JsonPathsExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public JsonPathsExpr(List<Expr> args) {
                    super(this$0, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    StructuredDataProcessor.ProcessResults info = processor.processFields(NestedDataExpressions.unwrap(input));
                    List transformed = info.getLiteralFields().stream().map(NestedPathFinder::toNormalizedJsonPath).collect(Collectors.toList());
                    return ExprEval.ofType(ExpressionType.STRING_ARRAY, transformed);
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.STRING_ARRAY;
                }
            }
            return new JsonPathsExpr(args);
        }
    }

    public static class JsonQueryArrayExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_query_array";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            if (args.get(1).isLiteral()) {
                return new JsonQueryArrayExpr(args);
            }
            return new JsonQueryArrayDynamicExpr(args);
        }

        final class JsonQueryArrayDynamicExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            public JsonQueryArrayDynamicExpr(List<Expr> args) {
                super(JsonQueryArrayExprMacro.this, args);
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                ExprEval path = ((Expr)this.args.get(1)).eval(bindings);
                List<NestedPathPart> parts = NestedPathFinder.parseJsonPath(path.asString());
                Object value = NestedPathFinder.find(NestedDataExpressions.unwrap(input), parts);
                if (value instanceof List) {
                    return ExprEval.ofArray(JSON_ARRAY, ExprEval.bestEffortArray((List)value).asArray());
                }
                return ExprEval.ofArray(JSON_ARRAY, ExprEval.bestEffortOf(value).asArray());
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return JSON_ARRAY;
            }
        }

        final class JsonQueryArrayExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private final List<NestedPathPart> parts;

            public JsonQueryArrayExpr(List<Expr> args) {
                super(JsonQueryArrayExprMacro.this, args);
                this.parts = NestedDataExpressions.getJsonPathPartsFromLiteral(JsonQueryArrayExprMacro.this, args.get(1));
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                Object value = NestedPathFinder.find(NestedDataExpressions.unwrap(input), this.parts);
                if (value instanceof List) {
                    return ExprEval.ofArray(JSON_ARRAY, ExprEval.bestEffortArray((List)value).asArray());
                }
                return ExprEval.ofArray(JSON_ARRAY, ExprEval.bestEffortOf(value).asArray());
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.NESTED_DATA;
            }
        }
    }

    public static class JsonQueryExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_query";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            if (args.get(1).isLiteral()) {
                return new JsonQueryExpr(args);
            }
            return new JsonQueryDynamicExpr(args);
        }

        final class JsonQueryDynamicExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            public JsonQueryDynamicExpr(List<Expr> args) {
                super(JsonQueryExprMacro.this, args);
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                ExprEval path = ((Expr)this.args.get(1)).eval(bindings);
                List<NestedPathPart> parts = NestedPathFinder.parseJsonPath(path.asString());
                return ExprEval.ofComplex(ExpressionType.NESTED_DATA, NestedPathFinder.find(NestedDataExpressions.unwrap(input), parts));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.NESTED_DATA;
            }
        }

        final class JsonQueryExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private final List<NestedPathPart> parts;

            public JsonQueryExpr(List<Expr> args) {
                super(JsonQueryExprMacro.this, args);
                this.parts = NestedDataExpressions.getJsonPathPartsFromLiteral(JsonQueryExprMacro.this, args.get(1));
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                return ExprEval.ofComplex(ExpressionType.NESTED_DATA, NestedPathFinder.find(NestedDataExpressions.unwrap(input), this.parts));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.NESTED_DATA;
            }
        }
    }

    public static class JsonValueExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_value";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            if (args.get(1).isLiteral()) {
                if (args.size() == 3 && args.get(2).isLiteral()) {
                    return new JsonValueCastExpr(args);
                }
                return new JsonValueExpr(args);
            }
            return new JsonValueDynamicExpr(args);
        }

        final class JsonValueDynamicExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            public JsonValueDynamicExpr(List<Expr> args) {
                super(JsonValueExprMacro.this, args);
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExpressionType castTo;
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                ExprEval path = ((Expr)this.args.get(1)).eval(bindings);
                if (this.args.size() == 3) {
                    castTo = ExpressionType.fromString(((Expr)this.args.get(2)).eval(bindings).asString());
                    if (castTo == null) {
                        throw JsonValueExprMacro.this.validationFailed("invalid output type: [%s]", ((Expr)this.args.get(2)).getLiteralValue());
                    }
                } else {
                    castTo = null;
                }
                List<NestedPathPart> parts = NestedPathFinder.parseJsonPath(path.asString());
                ExprEval valAtPath = ExprEval.bestEffortOf(NestedPathFinder.find(NestedDataExpressions.unwrap(input), parts));
                if (valAtPath.type().isPrimitive() || valAtPath.type().isPrimitiveArray()) {
                    return castTo == null ? valAtPath : valAtPath.castTo(castTo);
                }
                return castTo == null ? ExprEval.of(null) : ExprEval.ofType(castTo, null);
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return null;
            }
        }

        final class JsonValueCastExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private final List<NestedPathPart> parts;
            private final ExpressionType castTo;

            public JsonValueCastExpr(List<Expr> args) {
                super(JsonValueExprMacro.this, args);
                this.parts = NestedDataExpressions.getJsonPathPartsFromLiteral(JsonValueExprMacro.this, args.get(1));
                this.castTo = ExpressionType.fromString((String)args.get(2).getLiteralValue());
                if (this.castTo == null) {
                    throw JsonValueExprMacro.this.validationFailed("invalid output type: [%s]", args.get(2).getLiteralValue());
                }
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                ExprEval valAtPath = ExprEval.bestEffortOf(NestedPathFinder.find(NestedDataExpressions.unwrap(input), this.parts));
                if (valAtPath.type().isPrimitive() || valAtPath.type().isPrimitiveArray()) {
                    return valAtPath.castTo(this.castTo);
                }
                return ExprEval.ofType(this.castTo, null);
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return this.castTo;
            }
        }

        final class JsonValueExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private final List<NestedPathPart> parts;

            public JsonValueExpr(List<Expr> args) {
                super(JsonValueExprMacro.this, args);
                this.parts = NestedDataExpressions.getJsonPathPartsFromLiteral(JsonValueExprMacro.this, args.get(1));
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                ExprEval valAtPath = ExprEval.bestEffortOf(NestedPathFinder.find(NestedDataExpressions.unwrap(input), this.parts));
                if (valAtPath.type().isPrimitive() || valAtPath.type().isPrimitiveArray()) {
                    return valAtPath;
                }
                return ExprEval.of(null);
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return null;
            }
        }
    }

    public static class TryParseJsonExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "try_parse_json";
        private final ObjectMapper jsonMapper;

        @Inject
        public TryParseJsonExprMacro(@Json ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final class ParseJsonExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public ParseJsonExpr(List<Expr> args) {
                    super(TryParseJsonExprMacro.this, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval arg = ((Expr)this.args.get(0)).eval(bindings);
                    if (arg.type().is(ExprType.STRING) && arg.value() != null) {
                        try {
                            return ExprEval.ofComplex(ExpressionType.NESTED_DATA, TryParseJsonExprMacro.this.jsonMapper.readValue(arg.asString(), Object.class));
                        }
                        catch (JsonProcessingException e) {
                            return ExprEval.ofComplex(ExpressionType.NESTED_DATA, null);
                        }
                    }
                    return ExprEval.ofComplex(ExpressionType.NESTED_DATA, null);
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new ParseJsonExpr(args);
        }
    }

    public static class ParseJsonExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "parse_json";
        private final ObjectMapper jsonMapper;

        @Inject
        public ParseJsonExprMacro(@Json ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final class ParseJsonExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public ParseJsonExpr(List<Expr> args) {
                    super(ParseJsonExprMacro.this, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval arg = ((Expr)this.args.get(0)).eval(bindings);
                    if (arg.value() == null) {
                        return ExprEval.ofComplex(ExpressionType.NESTED_DATA, null);
                    }
                    if (arg.type().is(ExprType.STRING)) {
                        try {
                            return ExprEval.ofComplex(ExpressionType.NESTED_DATA, ParseJsonExprMacro.this.jsonMapper.readValue(arg.asString(), Object.class));
                        }
                        catch (JsonProcessingException e) {
                            throw ParseJsonExprMacro.this.processingFailed(e, "bad string input [%s]", arg.asString());
                        }
                    }
                    throw ParseJsonExprMacro.this.validationFailed("invalid input expected %s but got %s instead", ExpressionType.STRING, arg.type());
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new ParseJsonExpr(args);
        }
    }

    public static class ToJsonStringExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "to_json_string";
        private final ObjectMapper jsonMapper;

        @Inject
        public ToJsonStringExprMacro(@Json ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final class ToJsonStringExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public ToJsonStringExpr(List<Expr> args) {
                    super(ToJsonStringExprMacro.this, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    try {
                        Object unwrapped = NestedDataExpressions.unwrap(input);
                        String stringify = unwrapped == null ? null : ToJsonStringExprMacro.this.jsonMapper.writeValueAsString(unwrapped);
                        return ExprEval.ofType(ExpressionType.STRING, stringify);
                    }
                    catch (JsonProcessingException e) {
                        throw ToJsonStringExprMacro.this.processingFailed(e, "unable to stringify [%s] to JSON", input.value());
                    }
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.STRING;
                }
            }
            return new ToJsonStringExpr(args);
        }
    }

    public static class JsonObjectExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_object";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            if (args.size() % 2 != 0) {
                throw this.validationFailed("must have an even number of arguments", new Object[0]);
            }
            class StructExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public StructExpr(List<Expr> args) {
                    super(JsonObjectExprMacro.this, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    HashMap<String, Object> theMap = new HashMap<String, Object>();
                    for (int i = 0; i < this.args.size(); i += 2) {
                        ExprEval field = ((Expr)this.args.get(i)).eval(bindings);
                        ExprEval value = ((Expr)this.args.get(i + 1)).eval(bindings);
                        if (!field.type().is(ExprType.STRING)) {
                            throw JsonObjectExprMacro.this.validationFailed("field name must be a STRING", new Object[0]);
                        }
                        theMap.put(field.asString(), NestedDataExpressions.unwrap(value));
                    }
                    return ExprEval.ofComplex(ExpressionType.NESTED_DATA, theMap);
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new StructExpr(args);
        }
    }
}

