/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressMatchExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv4_match";
    private static final int ARG_SUBNET = 1;

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        try {
            final Expr arg = args.get(0);
            final IPAddressString blockString = this.getSubnetInfo(args);
            final IPAddress block = blockString.toAddress().toPrefixBlock();
            class IPv4AddressMatchExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                IPv4AddressMatchExpr(List<Expr> args) {
                    super(this$0, args);
                }

                @Override
                @Nonnull
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    boolean match;
                    ExprEval eval = arg.eval(bindings);
                    switch ((ExprType)eval.type().getType()) {
                        case STRING: {
                            match = this.isStringMatch(eval.asString());
                            break;
                        }
                        case LONG: {
                            match = !eval.isNumericNull() && this.isLongMatch(eval.asLong());
                            break;
                        }
                        default: {
                            match = false;
                        }
                    }
                    return ExprEval.ofLongBoolean(match);
                }

                private boolean isStringMatch(String stringValue) {
                    IPAddressString addressString = IPv4AddressExprUtils.parseString(stringValue);
                    return addressString != null && blockString.prefixContains(addressString);
                }

                private boolean isLongMatch(long longValue) {
                    IPv4Address address = IPv4AddressExprUtils.parse(longValue);
                    return address != null && block.contains((IPAddress)address);
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.LONG;
                }
            }
            return new IPv4AddressMatchExpr(args);
        }
        catch (AddressStringException e) {
            throw this.processingFailed(e, "failed to parse address", new Object[0]);
        }
    }

    private IPAddressString getSubnetInfo(List<Expr> args) {
        String subnetArgName = "subnet";
        Expr arg = args.get(1);
        this.validationHelperCheckArgIsLiteral(arg, subnetArgName);
        String subnet = (String)arg.getLiteralValue();
        if (!IPv4AddressExprUtils.isValidIPv4Subnet(subnet)) {
            throw this.validationFailed(subnetArgName + " arg has an invalid format: " + subnet, new Object[0]);
        }
        return new IPAddressString(subnet);
    }
}

