/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;

class IdentifierExpr
implements Expr {
    final String identifier;
    final String binding;

    IdentifierExpr(String value) {
        this.identifier = value;
        this.binding = value;
    }

    IdentifierExpr(String identifier, String binding) {
        this.identifier = identifier;
        this.binding = binding;
    }

    public String toString() {
        return this.binding;
    }

    @Nullable
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getBinding() {
        return this.binding;
    }

    @Override
    public boolean isIdentifier() {
        return true;
    }

    @Override
    @Nullable
    public String getIdentifierIfIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getBindingIfIdentifier() {
        return this.binding;
    }

    @Override
    @Nullable
    public IdentifierExpr getIdentifierExprIfIdentifierExpr() {
        return this;
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        return new Expr.BindingAnalysis(this);
    }

    @Override
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return inspector.getType(this.binding);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofType(bindings.getType(this.binding), bindings.get(this.binding));
    }

    @Override
    public String stringify() {
        return StringUtils.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.binding));
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return true;
    }

    public ExprVectorProcessor<?> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.identifier(inspector, this.binding);
    }

    @Override
    @Nullable
    public ColumnIndexSupplier asColumnIndexSupplier(ColumnIndexSelector indexSelector, @Nullable ColumnType outputType) {
        return indexSelector.getIndexSupplier(this.binding);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierExpr that = (IdentifierExpr)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

