/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class CgroupUtil {
    private static final Logger LOG = new Logger(CgroupUtil.class);
    public static final String SPACE_MATCH = Pattern.quote(" ");
    public static final String COMMA_MATCH = Pattern.quote(",");

    public static long readLongValue(CgroupDiscoverer discoverer, String cgroup, String fileName, long defaultValue) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(discoverer.discover(cgroup).toString(), fileName));
            return lines.stream().map(Longs::tryParse).filter(Objects::nonNull).findFirst().orElse(defaultValue);
        }
        catch (IOException | RuntimeException ex) {
            LOG.warn(ex, "Unable to fetch %s", fileName);
            return defaultValue;
        }
    }
}

