/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.granularity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Query;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.chrono.ISOChronology;

public class Granularities {
    public static final Granularity SECOND = GranularityType.SECOND.getDefaultGranularity();
    public static final Granularity MINUTE = GranularityType.MINUTE.getDefaultGranularity();
    public static final Granularity FIVE_MINUTE = GranularityType.FIVE_MINUTE.getDefaultGranularity();
    public static final Granularity TEN_MINUTE = GranularityType.TEN_MINUTE.getDefaultGranularity();
    public static final Granularity FIFTEEN_MINUTE = GranularityType.FIFTEEN_MINUTE.getDefaultGranularity();
    public static final Granularity THIRTY_MINUTE = GranularityType.THIRTY_MINUTE.getDefaultGranularity();
    public static final Granularity HOUR = GranularityType.HOUR.getDefaultGranularity();
    public static final Granularity SIX_HOUR = GranularityType.SIX_HOUR.getDefaultGranularity();
    public static final Granularity EIGHT_HOUR = GranularityType.EIGHT_HOUR.getDefaultGranularity();
    public static final Granularity DAY = GranularityType.DAY.getDefaultGranularity();
    public static final Granularity WEEK = GranularityType.WEEK.getDefaultGranularity();
    public static final Granularity MONTH = GranularityType.MONTH.getDefaultGranularity();
    public static final Granularity QUARTER = GranularityType.QUARTER.getDefaultGranularity();
    public static final Granularity YEAR = GranularityType.YEAR.getDefaultGranularity();
    public static final Granularity ALL = GranularityType.ALL.getDefaultGranularity();
    public static final Granularity NONE = GranularityType.NONE.getDefaultGranularity();
    public static final String GRANULARITY_VIRTUAL_COLUMN_NAME = "__virtualGranularity";

    public static Granularity nullToAll(Granularity granularity) {
        return granularity == null ? ALL : granularity;
    }

    public static CursorBuildSpec decorateCursorBuildSpec(Query<?> query, CursorBuildSpec buildSpec) {
        if (ALL.equals(query.getGranularity())) {
            return buildSpec;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set<String> requiredColumns = query.getRequiredColumns();
        if (requiredColumns != null) {
            builder.addAll(requiredColumns);
        }
        builder.addAll(query.getVirtualColumns().getColumnNames());
        ImmutableSet columnNamesForConflictResolution = builder.build();
        String virtualColumnName = GRANULARITY_VIRTUAL_COLUMN_NAME;
        int ctr = 0;
        while (columnNamesForConflictResolution.contains(virtualColumnName)) {
            virtualColumnName = virtualColumnName + ctr++;
        }
        ExpressionVirtualColumn granularityVirtual = Granularities.toVirtualColumn(query.getGranularity(), virtualColumnName);
        Preconditions.checkNotNull((Object)granularityVirtual, (String)"Granularity virtual column is null for granularity[%s]", (Object)query.getGranularity());
        VirtualColumns virtualColumns = VirtualColumns.fromIterable(Iterables.concat(Collections.singletonList(granularityVirtual), () -> Arrays.stream(buildSpec.getVirtualColumns().getVirtualColumns()).iterator()));
        ImmutableList.Builder groupingColumnsBuilder = ImmutableList.builder();
        groupingColumnsBuilder.add((Object)granularityVirtual.getOutputName());
        if (buildSpec.getGroupingColumns() != null) {
            groupingColumnsBuilder.addAll(buildSpec.getGroupingColumns());
        }
        return CursorBuildSpec.builder(buildSpec).setVirtualColumns(virtualColumns).setGroupingColumns((List<String>)groupingColumnsBuilder.build()).build();
    }

    @Nullable
    public static ExpressionVirtualColumn toVirtualColumn(Granularity granularity, String virtualColumnName) {
        String expression;
        if (ALL.equals(granularity)) {
            return null;
        }
        if (NONE.equals(granularity) || granularity instanceof DurationGranularity) {
            expression = "__time";
        } else {
            PeriodGranularity period = (PeriodGranularity)granularity;
            expression = !ISOChronology.getInstanceUTC().getZone().equals((Object)period.getTimeZone()) || period.getOrigin() != null ? "__time" : TimestampFloorExprMacro.forQueryGranularity(period.getPeriod());
        }
        return new ExpressionVirtualColumn(virtualColumnName, expression, ColumnType.LONG, ExprMacroTable.granularity());
    }

    @Nullable
    public static Granularity fromVirtualColumn(VirtualColumn virtualColumn) {
        TimestampFloorExprMacro.TimestampFloorExpr gran;
        ExpressionVirtualColumn expressionVirtualColumn;
        Expr expr;
        if (virtualColumn instanceof ExpressionVirtualColumn && (expr = (Expr)(expressionVirtualColumn = (ExpressionVirtualColumn)virtualColumn).getParsedExpression().get()) instanceof TimestampFloorExprMacro.TimestampFloorExpr && (gran = (TimestampFloorExprMacro.TimestampFloorExpr)expr).getArg().getBindingIfIdentifier() != null) {
            return gran.getGranularity();
        }
        return null;
    }
}

