/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.cast;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.write.cast.TypeCastSelectors;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;

public class ObjectToNumberColumnValueSelector
implements ColumnValueSelector<Number> {
    private final ColumnValueSelector<?> selector;
    private final ExpressionType desiredType;
    @Nullable
    private final RowIdSupplier rowIdSupplier;
    @Nullable
    private Number currentValue;
    private long currentRowId = -1L;

    ObjectToNumberColumnValueSelector(ColumnValueSelector<?> selector, ExpressionType desiredType, @Nullable RowIdSupplier rowIdSupplier) {
        this.selector = selector;
        this.desiredType = desiredType;
        this.rowIdSupplier = rowIdSupplier;
        if (!desiredType.isNumeric()) {
            throw DruidException.defensive("Expected numeric type, got[%s]", desiredType);
        }
    }

    @Override
    public double getDouble() {
        Number n = this.computeIfNeeded();
        return n == null ? NullHandling.ZERO_DOUBLE.doubleValue() : n.doubleValue();
    }

    @Override
    public float getFloat() {
        Number n = this.computeIfNeeded();
        return n == null ? NullHandling.ZERO_FLOAT.floatValue() : n.floatValue();
    }

    @Override
    public long getLong() {
        Number n = this.computeIfNeeded();
        return n == null ? NullHandling.ZERO_LONG.longValue() : n.longValue();
    }

    @Override
    public boolean isNull() {
        return this.computeIfNeeded() == null;
    }

    @Override
    @Nullable
    public Number getObject() {
        return this.computeIfNeeded();
    }

    @Override
    public Class<Number> classOfObject() {
        return Number.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("rowIdSupplier", this.rowIdSupplier);
    }

    @Nullable
    private Number computeIfNeeded() {
        if (this.rowIdSupplier == null) {
            return this.eval();
        }
        long rowId = this.rowIdSupplier.getRowId();
        if (this.currentRowId != rowId) {
            this.currentValue = this.eval();
            this.currentRowId = rowId;
        }
        return this.currentValue;
    }

    @Nullable
    private Number eval() {
        return (Number)TypeCastSelectors.bestEffortCoerce(this.selector.getObject(), this.desiredType);
    }
}

