/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.MultiColumnSelectorFactory;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.processor.TournamentTree;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.ColumnSelectorFactory;

public class FrameChannelMerger
implements FrameProcessor<Long> {
    private static final long UNLIMITED = -1L;
    private final List<ReadableFrameChannel> inputChannels;
    private final WritableFrameChannel outputChannel;
    private final FrameReader frameReader;
    private final List<KeyColumn> sortKey;
    private final ClusterByPartitions partitions;
    private final TournamentTree tournamentTree;
    private final FrameWriterFactory frameWriterFactory;
    private final FramePlus[] currentFrames;
    private final long rowLimit;
    private long rowsOutput = 0L;
    private int currentPartition = 0;
    private final IntSet remainingChannels;
    final MultiColumnSelectorFactory mergedColumnSelectorFactory;

    public FrameChannelMerger(List<ReadableFrameChannel> inputChannels, FrameReader frameReader, WritableFrameChannel outputChannel, FrameWriterFactory frameWriterFactory, List<KeyColumn> sortKey, @Nullable ClusterByPartitions partitions, long rowLimit) {
        ClusterByPartitions partitionsToUse;
        if (inputChannels.isEmpty()) {
            throw new IAE("Must have at least one input channel", new Object[0]);
        }
        ClusterByPartitions clusterByPartitions = partitionsToUse = partitions == null ? ClusterByPartitions.oneUniversalPartition() : partitions;
        if (!partitionsToUse.allAbutting()) {
            throw new IAE("Partitions must all abut each other", new Object[0]);
        }
        if (!sortKey.stream().allMatch(keyColumn -> keyColumn.order().sortable())) {
            throw new IAE("Key is not sortable", new Object[0]);
        }
        this.inputChannels = inputChannels;
        this.outputChannel = outputChannel;
        this.frameReader = frameReader;
        this.frameWriterFactory = frameWriterFactory;
        this.sortKey = sortKey;
        this.partitions = partitionsToUse;
        this.rowLimit = rowLimit;
        this.currentFrames = new FramePlus[inputChannels.size()];
        this.remainingChannels = new IntAVLTreeSet((IntCollection)IntSets.fromTo((int)0, (int)inputChannels.size()));
        this.tournamentTree = new TournamentTree(inputChannels.size(), (k1, k2) -> {
            FramePlus frame1 = this.currentFrames[k1];
            FramePlus frame2 = this.currentFrames[k2];
            if (frame1 == frame2) {
                return 0;
            }
            if (frame1 == null) {
                return 1;
            }
            if (frame2 == null) {
                return -1;
            }
            return this.currentFrames[k1].comparisonWidget.compare(this.currentFrames[k1].rowNumber(), this.currentFrames[k2].comparisonWidget, this.currentFrames[k2].rowNumber());
        });
        ArrayList<Supplier<ColumnSelectorFactory>> frameColumnSelectorFactorySuppliers = new ArrayList<Supplier<ColumnSelectorFactory>>(inputChannels.size());
        int i = 0;
        while (i < inputChannels.size()) {
            int frameNumber = i++;
            frameColumnSelectorFactorySuppliers.add(() -> this.currentFrames[frameNumber].cursor.getColumnSelectorFactory());
        }
        this.mergedColumnSelectorFactory = new MultiColumnSelectorFactory(frameColumnSelectorFactorySuppliers, frameReader.signature()).withRowMemoryAndSignatureColumns();
    }

    @Override
    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    @Override
    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    @Override
    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        IntSet awaitSet = this.populateCurrentFramesAndTournamentTree();
        if (!awaitSet.isEmpty()) {
            return ReturnOrAwait.awaitAll(awaitSet);
        }
        if (this.finished()) {
            return ReturnOrAwait.returnObject(this.rowsOutput);
        }
        this.outputChannel.write(this.nextFrame());
        if (this.finished()) {
            return ReturnOrAwait.returnObject(this.rowsOutput);
        }
        return ReturnOrAwait.runAgain();
    }

    private FrameWithPartition nextFrame() {
        if (this.finished()) {
            throw new NoSuchElementException();
        }
        try (FrameWriter mergedFrameWriter = this.frameWriterFactory.newFrameWriter(this.mergedColumnSelectorFactory);){
            int mergedFramePartition = this.currentPartition;
            RowKey currentPartitionEnd = this.partitions.get(this.currentPartition).getEnd();
            while (!this.finished()) {
                FramePlus currentFrame;
                int currentChannel = this.tournamentTree.getMin();
                this.mergedColumnSelectorFactory.setCurrentFactory(currentChannel);
                if (currentPartitionEnd != null && (currentFrame = this.currentFrames[currentChannel]).comparisonWidget.compare(currentFrame.rowNumber(), currentPartitionEnd) >= 0) {
                    do {
                        ++this.currentPartition;
                    } while ((currentPartitionEnd = this.partitions.get(this.currentPartition).getEnd()) != null && currentFrame.comparisonWidget.compare(currentFrame.rowNumber(), currentPartitionEnd) >= 0);
                    if (mergedFrameWriter.getNumRows() != 0) break;
                    mergedFramePartition = this.currentPartition;
                }
                if (mergedFrameWriter.addSelection()) {
                    ++this.rowsOutput;
                } else {
                    if (mergedFrameWriter.getNumRows() != 0) break;
                    throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
                }
                if (this.rowLimit != -1L && this.rowsOutput >= this.rowLimit) {
                    Arrays.fill(this.currentFrames, null);
                    this.remainingChannels.clear();
                    continue;
                }
                FramePlus channelFramePlus = this.currentFrames[currentChannel];
                channelFramePlus.cursor.advance();
                if (!channelFramePlus.isDone()) continue;
                this.currentFrames[currentChannel] = null;
                ReadableFrameChannel channel = this.inputChannels.get(currentChannel);
                if (channel.canRead()) {
                    Frame frame = channel.read();
                    FramePlus framePlus = this.makeFramePlus(frame, this.frameReader);
                    if (framePlus.isDone()) break;
                    this.currentFrames[currentChannel] = framePlus;
                    continue;
                }
                if (!channel.isFinished()) break;
                this.remainingChannels.remove(currentChannel);
            }
            Frame nextFrame = Frame.wrap(mergedFrameWriter.toByteArray());
            FrameWithPartition frameWithPartition = new FrameWithPartition(nextFrame, mergedFramePartition);
            return frameWithPartition;
        }
    }

    private boolean finished() {
        return this.remainingChannels.isEmpty();
    }

    @Override
    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), new Closeable[0]);
    }

    private IntSet populateCurrentFramesAndTournamentTree() {
        IntOpenHashSet await = new IntOpenHashSet();
        for (int i = 0; i < this.inputChannels.size(); ++i) {
            if (this.currentFrames[i] != null || !this.remainingChannels.contains(i)) continue;
            ReadableFrameChannel channel = this.inputChannels.get(i);
            if (channel.canRead()) {
                Frame frame = channel.read();
                FramePlus framePlus = this.makeFramePlus(frame, this.frameReader);
                if (framePlus.isDone()) {
                    await.add(i);
                    continue;
                }
                this.currentFrames[i] = framePlus;
                continue;
            }
            if (channel.isFinished()) {
                this.remainingChannels.remove(i);
                continue;
            }
            await.add(i);
        }
        return await;
    }

    private FramePlus makeFramePlus(Frame frame, FrameReader frameReader) {
        FrameCursor cursor = FrameProcessors.makeCursor(frame, frameReader);
        FrameComparisonWidget comparisonWidget = frameReader.makeComparisonWidget(frame, this.sortKey);
        cursor.setCurrentRow(FrameChannelMerger.findRow(frame, comparisonWidget, this.partitions.get(0).getStart()));
        RowKey endRowKey = this.partitions.get(this.partitions.size() - 1).getEnd();
        int endRow = endRowKey == null ? frame.numRows() : FrameChannelMerger.findRow(frame, comparisonWidget, endRowKey);
        return new FramePlus(cursor, comparisonWidget, endRow);
    }

    static int findRow(Frame frame, FrameComparisonWidget comparisonWidget, @Nullable RowKey key) {
        if (key == null) {
            return 0;
        }
        int minIndex = 0;
        int maxIndex = frame.numRows();
        while (minIndex < maxIndex) {
            int currIndex = (minIndex + maxIndex) / 2;
            int cmp = comparisonWidget.compare(currIndex, key);
            if (cmp < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex;
        }
        return minIndex;
    }

    private static class FramePlus {
        private final FrameCursor cursor;
        private final FrameComparisonWidget comparisonWidget;
        private final int endRow;

        public FramePlus(FrameCursor cursor, FrameComparisonWidget comparisonWidget, int endRow) {
            this.cursor = cursor;
            this.comparisonWidget = comparisonWidget;
            this.endRow = endRow;
        }

        public int rowNumber() {
            return this.cursor.getCurrentRow();
        }

        public boolean isDone() {
            return this.cursor.getCurrentRow() >= this.endRow;
        }
    }
}

