/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class BlockingQueueFrameChannel {
    private static final Optional<Either<Throwable, FrameWithPartition>> END_MARKER = Optional.empty();
    private final int maxQueuedFrames;
    private final Object lock = new Object();
    private final Writable writable;
    private final Readable readable;
    @GuardedBy(value="lock")
    private final ArrayDeque<Optional<Either<Throwable, FrameWithPartition>>> queue;
    @GuardedBy(value="lock")
    private SettableFuture<?> readyForWritingFuture = null;
    @GuardedBy(value="lock")
    private SettableFuture<?> readyForReadingFuture = null;

    public BlockingQueueFrameChannel(int maxQueuedFrames) {
        if (maxQueuedFrames < 1 || maxQueuedFrames == Integer.MAX_VALUE) {
            throw new IAE("Cannot handle capacity of [%d]", maxQueuedFrames);
        }
        this.maxQueuedFrames = maxQueuedFrames;
        this.queue = new ArrayDeque(maxQueuedFrames + 1);
        this.writable = new Writable();
        this.readable = new Readable();
    }

    public WritableFrameChannel writable() {
        return this.writable;
    }

    public ReadableFrameChannel readable() {
        return this.readable;
    }

    public static BlockingQueueFrameChannel minimal() {
        return new BlockingQueueFrameChannel(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return END_MARKER.equals(this.queue.peek());
        }
    }

    @GuardedBy(value="lock")
    private void notifyWriter() {
        if (this.readyForWritingFuture != null) {
            SettableFuture<?> tmp = this.readyForWritingFuture;
            this.readyForWritingFuture = null;
            tmp.set(null);
        }
    }

    @GuardedBy(value="lock")
    private void notifyReader() {
        if (this.readyForReadingFuture != null) {
            SettableFuture<?> tmp = this.readyForReadingFuture;
            this.readyForReadingFuture = null;
            tmp.set(null);
        }
    }

    private class Readable
    implements ReadableFrameChannel {
        private Readable() {
        }

        @Override
        public boolean isFinished() {
            return BlockingQueueFrameChannel.this.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canRead() {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                return !BlockingQueueFrameChannel.this.queue.isEmpty() && !this.isFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Frame read() {
            Optional next;
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                if (this.isFinished()) {
                    throw new NoSuchElementException();
                }
                next = (Optional)BlockingQueueFrameChannel.this.queue.poll();
                if (next == null || !next.isPresent()) {
                    throw new NoSuchElementException();
                }
                BlockingQueueFrameChannel.this.notifyWriter();
            }
            return ((FrameWithPartition)((Either)next.get()).valueOrThrow()).frame();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<?> readabilityFuture() {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                if (!BlockingQueueFrameChannel.this.queue.isEmpty()) {
                    return Futures.immediateFuture(null);
                }
                if (BlockingQueueFrameChannel.this.readyForReadingFuture != null) {
                    return BlockingQueueFrameChannel.this.readyForReadingFuture;
                }
                return BlockingQueueFrameChannel.this.readyForReadingFuture = SettableFuture.create();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                BlockingQueueFrameChannel.this.queue.clear();
                BlockingQueueFrameChannel.this.notifyWriter();
            }
        }
    }

    private class Writable
    implements WritableFrameChannel {
        private Writable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(FrameWithPartition frame) {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                if (BlockingQueueFrameChannel.this.isFinished()) {
                    throw new ISE("Channel cannot accept new frames", new Object[0]);
                }
                if (BlockingQueueFrameChannel.this.queue.size() >= BlockingQueueFrameChannel.this.maxQueuedFrames) {
                    throw new ISE("Channel has no capacity", new Object[0]);
                }
                if (!BlockingQueueFrameChannel.this.queue.offer(Optional.of(Either.value(frame)))) {
                    throw new ISE("Channel had capacity, but could not add frame", new Object[0]);
                }
                BlockingQueueFrameChannel.this.notifyReader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<?> writabilityFuture() {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                if (BlockingQueueFrameChannel.this.queue.size() < BlockingQueueFrameChannel.this.maxQueuedFrames) {
                    return Futures.immediateFuture(null);
                }
                if (BlockingQueueFrameChannel.this.readyForWritingFuture != null) {
                    return BlockingQueueFrameChannel.this.readyForWritingFuture;
                }
                return BlockingQueueFrameChannel.this.readyForWritingFuture = SettableFuture.create();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fail(@Nullable Throwable cause) {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                BlockingQueueFrameChannel.this.queue.clear();
                if (!BlockingQueueFrameChannel.this.queue.offer(Optional.of(Either.error(cause != null ? cause : new ISE("Failed", new Object[0]))))) {
                    throw new ISE("Could not write error to channel", new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                if (this.isClosed()) {
                    throw new ISE("Already closed", new Object[0]);
                }
                if (!BlockingQueueFrameChannel.this.queue.offer(END_MARKER)) {
                    throw new ISE("Channel had capacity, but could not add end marker", new Object[0]);
                }
                BlockingQueueFrameChannel.this.notifyReader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClosed() {
            Object object = BlockingQueueFrameChannel.this.lock;
            synchronized (object) {
                Optional lastElement = (Optional)BlockingQueueFrameChannel.this.queue.peekLast();
                return END_MARKER.equals(lastElement);
            }
        }
    }
}

