/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class HttpInputSourceConfig {
    @VisibleForTesting
    public static final Set<String> DEFAULT_ALLOWED_PROTOCOLS = ImmutableSet.of((Object)"http", (Object)"https");
    @JsonProperty
    private final Set<String> allowedProtocols;

    @JsonCreator
    public HttpInputSourceConfig(@JsonProperty(value="allowedProtocols") @Nullable Set<String> allowedProtocols) {
        this.allowedProtocols = allowedProtocols == null || allowedProtocols.isEmpty() ? DEFAULT_ALLOWED_PROTOCOLS : allowedProtocols.stream().map(StringUtils::toLowerCase).collect(Collectors.toSet());
    }

    public Set<String> getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpInputSourceConfig that = (HttpInputSourceConfig)o;
        return Objects.equals(this.allowedProtocols, that.allowedProtocols);
    }

    public int hashCode() {
        return Objects.hash(this.allowedProtocols);
    }

    public String toString() {
        return "HttpInputSourceConfig{allowedProtocols=" + this.allowedProtocols + '}';
    }
}

