/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.ranger.authorizer;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.ranger.authorizer.RangerDruidAccessRequest;
import org.apache.druid.security.ranger.authorizer.RangerDruidResource;
import org.apache.druid.security.ranger.authorizer.guice.Ranger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.Resource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;

@JsonTypeName(value="ranger")
public class RangerAuthorizer
implements Authorizer {
    private static final Logger log = new Logger(RangerAuthorizer.class);
    public static final String RANGER_DRUID_SERVICETYPE = "druid";
    public static final String RANGER_DRUID_APPID = "druid";
    private final RangerBasePlugin rangerPlugin;
    private final boolean useUgi;

    @JsonCreator
    public RangerAuthorizer(@JsonProperty(value="keytab") String keytab, @JsonProperty(value="principal") String principal, @JsonProperty(value="use_ugi") boolean useUgi, @JacksonInject @Ranger Configuration conf) {
        this.useUgi = useUgi;
        UserGroupInformation.setConfiguration((Configuration)conf);
        if (keytab != null && principal != null) {
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        this.rangerPlugin = new RangerBasePlugin("druid", "druid");
        this.rangerPlugin.init();
        this.rangerPlugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler());
    }

    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
        if (authenticationResult == null) {
            throw new IAE("authenticationResult is null where it should never be.", new Object[0]);
        }
        HashSet<String> userGroups = null;
        if (this.useUgi) {
            String[] groups;
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)authenticationResult.getIdentity());
            String[] stringArray = groups = ugi != null ? ugi.getGroupNames() : null;
            if (groups != null && groups.length > 0) {
                userGroups = new HashSet<String>(Arrays.asList(groups));
            }
        }
        RangerDruidResource rangerDruidResource = new RangerDruidResource(resource);
        RangerDruidAccessRequest request = new RangerDruidAccessRequest(rangerDruidResource, authenticationResult.getIdentity(), userGroups, action);
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)request);
        if (log.isDebugEnabled()) {
            log.debug("==> authorize: %s, allowed: %s", new Object[]{request.toString(), result != null ? Boolean.valueOf(result.getIsAllowed()) : null});
        }
        if (result != null && result.getIsAllowed()) {
            return new Access(true);
        }
        return new Access(false);
    }
}

