/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.client.indexing.SamplerSpec;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

@Path(value="/druid/indexer/v1/sampler")
public class SamplerResource {
    private final AuthorizerMapper authorizerMapper;
    private final AuthConfig authConfig;
    private static final ResourceAction STATE_RESOURCE_WRITE = new ResourceAction(Resource.STATE_RESOURCE, Action.WRITE);

    @Inject
    public SamplerResource(AuthorizerMapper authorizerMapper, AuthConfig authConfig) {
        this.authorizerMapper = authorizerMapper;
        this.authConfig = authConfig;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SamplerResponse post(SamplerSpec sampler, @Context HttpServletRequest req) {
        Access authResult;
        Preconditions.checkNotNull((Object)sampler, (Object)"Request body cannot be empty");
        HashSet<ResourceAction> resourceActions = new HashSet<ResourceAction>();
        resourceActions.add(STATE_RESOURCE_WRITE);
        if (this.authConfig.isEnableInputSourceSecurity()) {
            resourceActions.addAll(sampler.getInputSourceResources());
        }
        if (!(authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resourceActions, (AuthorizerMapper)this.authorizerMapper)).isAllowed()) {
            throw new ForbiddenException(authResult.getMessage());
        }
        return sampler.sample();
    }
}

