/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.ArrayOfStringTuplesSerDe;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringDistribution;
import org.apache.druid.timeline.partition.PartitionBoundaries;

@JsonSerialize(using=Jackson.Serializer.class)
@JsonDeserialize(using=Jackson.Deserializer.class)
public class StringSketch
implements StringDistribution {
    static final String NAME = "sketch";
    static final int SKETCH_K = 4096;
    static final Comparator<StringTuple> STRING_TUPLE_COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfStringTuplesSerDe ARRAY_OF_STRINGS_SERDE = new ArrayOfStringTuplesSerDe();
    private final ItemsSketch<StringTuple> delegate;

    public StringSketch() {
        this((ItemsSketch<StringTuple>)ItemsSketch.getInstance(StringTuple.class, (int)4096, STRING_TUPLE_COMPARATOR));
    }

    StringSketch(ItemsSketch<StringTuple> sketch) {
        this.delegate = sketch;
    }

    @Override
    public void put(StringTuple string) {
        this.delegate.update((Object)string);
    }

    @Override
    public void putIfNewMin(StringTuple value) {
        if (this.delegate.isEmpty() || ((StringTuple)this.delegate.getMinItem()).compareTo(value) > 0) {
            this.delegate.update((Object)value);
        }
    }

    @Override
    public void putIfNewMax(StringTuple value) {
        if (this.delegate.isEmpty() || ((StringTuple)this.delegate.getMaxItem()).compareTo(value) < 0) {
            this.delegate.update((Object)value);
        }
    }

    @Override
    public PartitionBoundaries getEvenPartitionsByMaxSize(int maxSize) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (String)"maxSize must be positive but is %s", (int)maxSize);
        long n = this.delegate.getN();
        double delta = this.delegate.getNormalizedRankError(true) * (double)n;
        int targetSize = Math.max(1, (int)Math.floor((double)maxSize - delta));
        int evenPartitionCount = (int)Math.ceil((double)n / (double)targetSize);
        return this.getEvenPartitionsByCount(Math.max(1, evenPartitionCount));
    }

    @Override
    public PartitionBoundaries getEvenPartitionsByTargetSize(int targetSize) {
        Preconditions.checkArgument((targetSize > 0 ? 1 : 0) != 0, (String)"targetSize must be positive but is %s", (int)targetSize);
        long n = this.delegate.getN();
        int evenPartitionCount = Math.max(1, (int)Math.round((double)n / (double)targetSize));
        return this.getEvenPartitionsByCount(evenPartitionCount);
    }

    @VisibleForTesting
    public StringTuple getMin() {
        return (StringTuple)this.delegate.getMinItem();
    }

    @VisibleForTesting
    public StringTuple getMax() {
        return (StringTuple)this.delegate.getMaxItem();
    }

    private PartitionBoundaries getEvenPartitionsByCount(int evenPartitionCount) {
        Preconditions.checkArgument((evenPartitionCount > 0 ? 1 : 0) != 0, (String)"evenPartitionCount must be positive but is %s", (int)evenPartitionCount);
        if (this.delegate.isEmpty()) {
            return new PartitionBoundaries(new StringTuple[0]);
        }
        return new PartitionBoundaries((StringTuple[])this.delegate.getPartitionBoundaries((int)evenPartitionCount, (QuantileSearchCriteria)QuantileSearchCriteria.EXCLUSIVE).boundaries);
    }

    public String toString() {
        return "StringSketch{delegate=" + this.delegate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSketch that = (StringSketch)o;
        return this.delegate.getK() == that.delegate.getK() && this.delegate.getN() == that.delegate.getN() && Objects.equals(this.delegate.getMaxItem(), that.delegate.getMaxItem()) && Objects.equals(this.delegate.getMinItem(), that.delegate.getMinItem());
    }

    public int hashCode() {
        return Objects.hash(this.delegate.getK(), this.delegate.getN(), this.delegate.getMaxItem(), this.delegate.getMinItem());
    }

    ItemsSketch<StringTuple> getDelegate() {
        return this.delegate;
    }

    private byte[] toByteArray() {
        return this.delegate.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SERDE);
    }

    static class Jackson {
        private static final String FIELD_SKETCH = "sketch";

        Jackson() {
        }

        static class Deserializer
        extends StdDeserializer<StringSketch> {
            Deserializer() {
                super(StringSketch.class);
            }

            public StringSketch deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                byte[] sketchBytes = jsonNode.get("sketch").binaryValue();
                ItemsSketch sketch = ItemsSketch.getInstance(StringTuple.class, (Memory)Memory.wrap((byte[])sketchBytes), STRING_TUPLE_COMPARATOR, (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SERDE);
                return new StringSketch((ItemsSketch<StringTuple>)sketch);
            }
        }

        static class Serializer
        extends StdSerializer<StringSketch> {
            Serializer() {
                super(StringSketch.class);
            }

            public void serialize(StringSketch stringSketch, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeBinaryField("sketch", stringSketch.toByteArray());
            }

            public void serializeWithType(StringSketch value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
                typeSer.writeTypePrefixForObject((Object)value, gen);
                this.serialize(value, gen, serializers);
                typeSer.writeTypeSuffixForObject((Object)value, gen);
            }
        }
    }
}

