/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <K, V> Map<K, V> subtractMap(Map<? extends K, ? extends V> minuend, Map<? extends K, ? extends V> subtrahend) {
        return minuend.entrySet().stream().filter(entry -> !subtrahend.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T> Map<String, Map<Integer, T>> groupPartitionDataByTopic(Map<TopicPartition, ? extends T> data) {
        HashMap<String, Map<Integer, T>> dataByTopic = new HashMap<String, Map<Integer, T>>();
        for (Map.Entry<TopicPartition, T> entry : data.entrySet()) {
            String topic = entry.getKey().topic();
            int partition = entry.getKey().partition();
            Map topicData = dataByTopic.computeIfAbsent(topic, t -> new HashMap());
            topicData.put(partition, entry.getValue());
        }
        return dataByTopic;
    }

    public static Map<String, List<Integer>> groupPartitionsByTopic(Collection<TopicPartition> partitions) {
        return CollectionUtils.groupPartitionsByTopic(partitions, topic -> new ArrayList(), List::add);
    }

    public static <T> Map<String, T> groupPartitionsByTopic(Collection<TopicPartition> partitions, Function<String, T> buildGroup, BiConsumer<T, Integer> addToGroup) {
        HashMap<String, T> dataByTopic = new HashMap<String, T>();
        for (TopicPartition tp : partitions) {
            String topic = tp.topic();
            T topicData = dataByTopic.computeIfAbsent(topic, buildGroup);
            addToGroup.accept(topicData, tp.partition());
        }
        return dataByTopic;
    }
}

