/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collection;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.util.CopySortOrderFields;

public class SortOrderUtil {
    private SortOrderUtil() {
    }

    public static SortOrder buildSortOrder(Table table) {
        return SortOrderUtil.buildSortOrder(table.schema(), table.spec(), table.sortOrder());
    }

    static SortOrder buildSortOrder(Schema schema, PartitionSpec spec, SortOrder sortOrder) {
        if (sortOrder.isUnsorted() && spec.isUnpartitioned()) {
            return SortOrder.unsorted();
        }
        ImmutableListMultimap sortFieldIndex = Multimaps.index((Iterable)sortOrder.fields(), SortField::sourceId);
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema);
        for (PartitionField field : spec.fields()) {
            Collection sortFields = sortFieldIndex.get((Object)field.sourceId());
            boolean isSorted = sortFields.stream().anyMatch(sortField -> field.transform().equals(sortField.transform()) || sortField.transform().satisfiesOrderOf(field.transform()));
            if (isSorted) continue;
            String sourceName = schema.findColumnName(field.sourceId());
            builder.asc((Term)Expressions.transform((String)sourceName, (Transform)field.transform()));
        }
        SortOrderVisitor.visit((SortOrder)sortOrder, (SortOrderVisitor)new CopySortOrderFields(builder));
        return builder.build();
    }
}

