/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class DateTimeUtil {
    public static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    public static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();
    public static final long MICROS_PER_MILLIS = 1000L;

    private DateTimeUtil() {
    }

    public static LocalDate dateFromDays(int daysFromEpoch) {
        return ChronoUnit.DAYS.addTo(EPOCH_DAY, daysFromEpoch);
    }

    public static int daysFromDate(LocalDate date) {
        return (int)ChronoUnit.DAYS.between(EPOCH_DAY, date);
    }

    public static int daysFromInstant(Instant instant) {
        return (int)ChronoUnit.DAYS.between(EPOCH, instant.atOffset(ZoneOffset.UTC));
    }

    public static LocalTime timeFromMicros(long microFromMidnight) {
        return LocalTime.ofNanoOfDay(microFromMidnight * 1000L);
    }

    public static long microsFromTime(LocalTime time) {
        return time.toNanoOfDay() / 1000L;
    }

    public static LocalDateTime timestampFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch).toLocalDateTime();
    }

    public static long microsFromInstant(Instant instant) {
        return ChronoUnit.MICROS.between(EPOCH, instant.atOffset(ZoneOffset.UTC));
    }

    public static long microsFromTimestamp(LocalDateTime dateTime) {
        return ChronoUnit.MICROS.between(EPOCH, dateTime.atOffset(ZoneOffset.UTC));
    }

    public static long microsToMillis(long micros) {
        return Math.floorDiv(micros, 1000L);
    }

    public static OffsetDateTime timestamptzFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch);
    }

    public static long microsFromTimestamptz(OffsetDateTime dateTime) {
        return ChronoUnit.MICROS.between(EPOCH, dateTime);
    }
}

