/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;

public class OutputFileFactory {
    private final PartitionSpec defaultSpec;
    private final FileFormat format;
    private final LocationProvider locations;
    private final FileIO io;
    private final EncryptionManager encryptionManager;
    private final int partitionId;
    private final long taskId;
    private final String operationId;
    private final AtomicInteger fileCount = new AtomicInteger(0);

    @Deprecated
    public OutputFileFactory(Table table, FileFormat format, int partitionId, long taskId) {
        this(table.spec(), format, table.locationProvider(), table.io(), table.encryption(), partitionId, taskId, UUID.randomUUID().toString());
    }

    @Deprecated
    public OutputFileFactory(Table table, PartitionSpec spec, FileFormat format, int partitionId, long taskId) {
        this(spec, format, table.locationProvider(), table.io(), table.encryption(), partitionId, taskId, UUID.randomUUID().toString());
    }

    @Deprecated
    public OutputFileFactory(PartitionSpec spec, FileFormat format, LocationProvider locations, FileIO io, EncryptionManager encryptionManager, int partitionId, long taskId) {
        this(spec, format, locations, io, encryptionManager, partitionId, taskId, UUID.randomUUID().toString());
    }

    @Deprecated
    public OutputFileFactory(PartitionSpec spec, FileFormat format, LocationProvider locations, FileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, String operationId) {
        this.defaultSpec = spec;
        this.format = format;
        this.locations = locations;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.operationId = operationId;
    }

    public static Builder builderFor(Table table, int partitionId, long taskId) {
        return new Builder(table, partitionId, taskId);
    }

    private String generateFilename() {
        return this.format.addExtension(String.format("%05d-%d-%s-%05d", this.partitionId, this.taskId, this.operationId, this.fileCount.incrementAndGet()));
    }

    public EncryptedOutputFile newOutputFile() {
        OutputFile file = this.io.newOutputFile(this.locations.newDataLocation(this.generateFilename()));
        return this.encryptionManager.encrypt(file);
    }

    public EncryptedOutputFile newOutputFile(StructLike partition) {
        return this.newOutputFile(this.defaultSpec, partition);
    }

    public EncryptedOutputFile newOutputFile(PartitionSpec spec, StructLike partition) {
        String newDataLocation = this.locations.newDataLocation(spec, partition, this.generateFilename());
        OutputFile rawOutputFile = this.io.newOutputFile(newDataLocation);
        return this.encryptionManager.encrypt(rawOutputFile);
    }

    public static class Builder {
        private final Table table;
        private final int partitionId;
        private final long taskId;
        private PartitionSpec defaultSpec;
        private String operationId;
        private FileFormat format;

        private Builder(Table table, int partitionId, long taskId) {
            this.table = table;
            this.partitionId = partitionId;
            this.taskId = taskId;
            this.defaultSpec = table.spec();
            this.operationId = UUID.randomUUID().toString();
            String formatAsString = table.properties().getOrDefault("write.format.default", "parquet");
            this.format = FileFormat.valueOf((String)formatAsString.toUpperCase(Locale.ROOT));
        }

        public Builder defaultSpec(PartitionSpec newDefaultSpec) {
            this.defaultSpec = newDefaultSpec;
            return this;
        }

        public Builder operationId(String newOperationId) {
            this.operationId = newOperationId;
            return this;
        }

        public Builder format(FileFormat newFormat) {
            this.format = newFormat;
            return this;
        }

        public OutputFileFactory build() {
            LocationProvider locations = this.table.locationProvider();
            FileIO io = this.table.io();
            EncryptionManager encryption = this.table.encryption();
            return new OutputFileFactory(this.defaultSpec, this.format, locations, io, encryption, this.partitionId, this.taskId, this.operationId);
        }
    }
}

