/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;

public class TableMetadata
implements Serializable {
    static final long INITIAL_SEQUENCE_NUMBER = 0L;
    static final long INVALID_SEQUENCE_NUMBER = -1L;
    static final int DEFAULT_TABLE_FORMAT_VERSION = 1;
    static final int SUPPORTED_TABLE_FORMAT_VERSION = 2;
    static final int INITIAL_SPEC_ID = 0;
    static final int INITIAL_SORT_ORDER_ID = 1;
    static final int INITIAL_SCHEMA_ID = 0;
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final transient InputFile file;
    private final String metadataFileLocation;
    private final int formatVersion;
    private final String uuid;
    private final String location;
    private final long lastSequenceNumber;
    private final long lastUpdatedMillis;
    private final int lastColumnId;
    private final int currentSchemaId;
    private final List<Schema> schemas;
    private final int defaultSpecId;
    private final List<PartitionSpec> specs;
    private final int lastAssignedPartitionId;
    private final int defaultSortOrderId;
    private final List<SortOrder> sortOrders;
    private final Map<String, String> properties;
    private final long currentSnapshotId;
    private final List<Snapshot> snapshots;
    private final Map<Long, Snapshot> snapshotsById;
    private final Map<Integer, Schema> schemasById;
    private final Map<Integer, PartitionSpec> specsById;
    private final Map<Integer, SortOrder> sortOrdersById;
    private final List<HistoryEntry> snapshotLog;
    private final List<MetadataLogEntry> previousFiles;

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties) {
        int formatVersion = PropertyUtil.propertyAsInt(properties, "format-version", 1);
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, TableMetadata.unreservedProperties(properties), formatVersion);
    }

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        SortOrder sortOrder = SortOrder.unsorted();
        int formatVersion = PropertyUtil.propertyAsInt(properties, "format-version", 1);
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, TableMetadata.unreservedProperties(properties), formatVersion);
    }

    private static Map<String, String> unreservedProperties(Map<String, String> rawProperties) {
        return rawProperties.entrySet().stream().filter(e -> !TableProperties.RESERVED_PROPERTIES.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties, int formatVersion) {
        Preconditions.checkArgument((boolean)properties.keySet().stream().noneMatch(TableProperties.RESERVED_PROPERTIES::contains), (String)"Table properties should not contain reserved properties, but got %s", properties);
        AtomicInteger lastColumnId = new AtomicInteger(0);
        Schema freshSchema = TypeUtil.assignFreshIds((int)0, (Schema)schema, lastColumnId::incrementAndGet);
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)freshSchema).withSpecId(0);
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            specBuilder.add(freshSchema.findField(sourceName).fieldId(), field.name(), field.transform().toString());
        }
        PartitionSpec freshSpec = specBuilder.build();
        int freshSortOrderId = sortOrder.isUnsorted() ? sortOrder.orderId() : 1;
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(freshSortOrderId, freshSchema, sortOrder);
        MetricsConfig.fromProperties(properties).validateReferencedColumns(schema);
        return new TableMetadata(null, formatVersion, UUID.randomUUID().toString(), location, 0L, System.currentTimeMillis(), lastColumnId.get(), freshSchema.schemaId(), (List<Schema>)ImmutableList.of((Object)freshSchema), freshSpec.specId(), (List<PartitionSpec>)ImmutableList.of((Object)freshSpec), freshSpec.lastAssignedFieldId(), freshSortOrderId, (List<SortOrder>)ImmutableList.of((Object)freshSortOrder), (Map<String, String>)ImmutableMap.copyOf(properties), -1L, (List<Snapshot>)ImmutableList.of(), (List<HistoryEntry>)ImmutableList.of(), (List<MetadataLogEntry>)ImmutableList.of());
    }

    TableMetadata(InputFile file, int formatVersion, String uuid, String location, long lastSequenceNumber, long lastUpdatedMillis, int lastColumnId, int currentSchemaId, List<Schema> schemas, int defaultSpecId, List<PartitionSpec> specs, int lastAssignedPartitionId, int defaultSortOrderId, List<SortOrder> sortOrders, Map<String, String> properties, long currentSnapshotId, List<Snapshot> snapshots, List<HistoryEntry> snapshotLog, List<MetadataLogEntry> previousFiles) {
        Preconditions.checkArgument((specs != null && !specs.isEmpty() ? 1 : 0) != 0, (Object)"Partition specs cannot be null or empty");
        Preconditions.checkArgument((sortOrders != null && !sortOrders.isEmpty() ? 1 : 0) != 0, (Object)"Sort orders cannot be null or empty");
        Preconditions.checkArgument((formatVersion <= 2 ? 1 : 0) != 0, (String)"Unsupported format version: v%s", (int)formatVersion);
        Preconditions.checkArgument((formatVersion == 1 || uuid != null ? 1 : 0) != 0, (String)"UUID is required in format v%s", (int)formatVersion);
        Preconditions.checkArgument((formatVersion > 1 || lastSequenceNumber == 0L ? 1 : 0) != 0, (String)"Sequence number must be 0 in v1: %s", (long)lastSequenceNumber);
        this.formatVersion = formatVersion;
        this.file = file;
        this.metadataFileLocation = file != null ? file.location() : null;
        this.uuid = uuid;
        this.location = location;
        this.lastSequenceNumber = lastSequenceNumber;
        this.lastUpdatedMillis = lastUpdatedMillis;
        this.lastColumnId = lastColumnId;
        this.currentSchemaId = currentSchemaId;
        this.schemas = schemas;
        this.specs = specs;
        this.defaultSpecId = defaultSpecId;
        this.lastAssignedPartitionId = lastAssignedPartitionId;
        this.defaultSortOrderId = defaultSortOrderId;
        this.sortOrders = sortOrders;
        this.properties = properties;
        this.currentSnapshotId = currentSnapshotId;
        this.snapshots = snapshots;
        this.snapshotLog = snapshotLog;
        this.previousFiles = previousFiles;
        this.snapshotsById = TableMetadata.indexAndValidateSnapshots(snapshots, lastSequenceNumber);
        this.schemasById = this.indexSchemas();
        this.specsById = TableMetadata.indexSpecs(specs);
        this.sortOrdersById = TableMetadata.indexSortOrders(sortOrders);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : snapshotLog) {
            if (last != null) {
                Preconditions.checkArgument((logEntry.timestampMillis() - last.timestampMillis() >= -ONE_MINUTE ? 1 : 0) != 0, (Object)"[BUG] Expected sorted snapshot log entries.");
            }
            last = logEntry;
        }
        if (last != null) {
            Preconditions.checkArgument((lastUpdatedMillis - last.timestampMillis() >= -ONE_MINUTE ? 1 : 0) != 0, (String)"Invalid update timestamp %s: before last snapshot log entry at %s", (long)lastUpdatedMillis, (long)last.timestampMillis());
        }
        MetadataLogEntry previous = null;
        for (MetadataLogEntry metadataEntry : previousFiles) {
            if (previous != null) {
                Preconditions.checkArgument((metadataEntry.timestampMillis() - previous.timestampMillis() >= -ONE_MINUTE ? 1 : 0) != 0, (Object)"[BUG] Expected sorted previous metadata log entries.");
            }
            previous = metadataEntry;
        }
        if (previous != null) {
            Preconditions.checkArgument((lastUpdatedMillis - previous.timestampMillis >= -ONE_MINUTE ? 1 : 0) != 0, (String)"Invalid update timestamp %s: before the latest metadata log entry timestamp %s", (long)lastUpdatedMillis, (long)previous.timestampMillis);
        }
        Preconditions.checkArgument((currentSnapshotId < 0L || this.snapshotsById.containsKey(currentSnapshotId) ? 1 : 0) != 0, (Object)"Invalid table metadata: Cannot find current version");
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String metadataFileLocation() {
        return this.metadataFileLocation;
    }

    public String uuid() {
        return this.uuid;
    }

    public long lastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public long nextSequenceNumber() {
        return this.formatVersion > 1 ? this.lastSequenceNumber + 1L : 0L;
    }

    public long lastUpdatedMillis() {
        return this.lastUpdatedMillis;
    }

    public int lastColumnId() {
        return this.lastColumnId;
    }

    public Schema schema() {
        return this.schemasById.get(this.currentSchemaId);
    }

    public List<Schema> schemas() {
        return this.schemas;
    }

    public Map<Integer, Schema> schemasById() {
        return this.schemasById;
    }

    public int currentSchemaId() {
        return this.currentSchemaId;
    }

    public PartitionSpec spec() {
        return this.specsById.get(this.defaultSpecId);
    }

    public PartitionSpec spec(int id) {
        return this.specsById.get(id);
    }

    public List<PartitionSpec> specs() {
        return this.specs;
    }

    public Map<Integer, PartitionSpec> specsById() {
        return this.specsById;
    }

    int lastAssignedPartitionId() {
        return this.lastAssignedPartitionId;
    }

    public int defaultSpecId() {
        return this.defaultSpecId;
    }

    public int defaultSortOrderId() {
        return this.defaultSortOrderId;
    }

    public SortOrder sortOrder() {
        return this.sortOrdersById.get(this.defaultSortOrderId);
    }

    public List<SortOrder> sortOrders() {
        return this.sortOrders;
    }

    public Map<Integer, SortOrder> sortOrdersById() {
        return this.sortOrdersById;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public boolean propertyAsBoolean(String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(this.properties, property, defaultValue);
    }

    public int propertyAsInt(String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(this.properties, property, defaultValue);
    }

    public long propertyAsLong(String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(this.properties, property, defaultValue);
    }

    public Snapshot snapshot(long snapshotId) {
        return this.snapshotsById.get(snapshotId);
    }

    public Snapshot currentSnapshot() {
        return this.snapshotsById.get(this.currentSnapshotId);
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public List<HistoryEntry> snapshotLog() {
        return this.snapshotLog;
    }

    public List<MetadataLogEntry> previousFiles() {
        return this.previousFiles;
    }

    public TableMetadata withUUID() {
        if (this.uuid != null) {
            return this;
        }
        return new TableMetadata(null, this.formatVersion, UUID.randomUUID().toString(), this.location, this.lastSequenceNumber, this.lastUpdatedMillis, this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata updateSchema(Schema newSchema, int newLastColumnId) {
        PartitionSpec.checkCompatibility((PartitionSpec)this.spec(), (Schema)newSchema);
        SortOrder.checkCompatibility((SortOrder)this.sortOrder(), (Schema)newSchema);
        List updatedSpecs = Lists.transform(this.specs, spec -> TableMetadata.updateSpecSchema(newSchema, spec));
        List updatedSortOrders = Lists.transform(this.sortOrders, order -> TableMetadata.updateSortOrderSchema(newSchema, order));
        int newSchemaId = this.reuseOrCreateNewSchemaId(newSchema);
        if (this.currentSchemaId == newSchemaId && newLastColumnId == this.lastColumnId) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.schemas);
        if (!this.schemasById.containsKey(newSchemaId)) {
            builder.add((Object)new Schema(newSchemaId, newSchema.columns(), newSchema.identifierFieldIds()));
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), newLastColumnId, newSchemaId, (List<Schema>)builder.build(), this.defaultSpecId, updatedSpecs, this.lastAssignedPartitionId, this.defaultSortOrderId, updatedSortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata updatePartitionSpec(PartitionSpec newPartitionSpec) {
        Schema schema = this.schema();
        PartitionSpec.checkCompatibility((PartitionSpec)newPartitionSpec, (Schema)schema);
        ValidationException.check((this.formatVersion > 1 || PartitionSpec.hasSequentialIds((PartitionSpec)newPartitionSpec) ? 1 : 0) != 0, (String)"Spec does not use sequential IDs that are required in v1: %s", (Object[])new Object[]{newPartitionSpec});
        int newDefaultSpecId = 0;
        for (PartitionSpec spec : this.specs) {
            if (newPartitionSpec.compatibleWith(spec)) {
                newDefaultSpecId = spec.specId();
                break;
            }
            if (newDefaultSpecId > spec.specId()) continue;
            newDefaultSpecId = spec.specId() + 1;
        }
        if (this.defaultSpecId == newDefaultSpecId) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.specs);
        if (!this.specsById.containsKey(newDefaultSpecId)) {
            builder.add((Object)TableMetadata.freshSpec(newDefaultSpecId, schema, newPartitionSpec));
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, newDefaultSpecId, (List<PartitionSpec>)builder.build(), Math.max(this.lastAssignedPartitionId, newPartitionSpec.lastAssignedFieldId()), this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata replaceSortOrder(SortOrder newOrder) {
        Schema schema = this.schema();
        SortOrder.checkCompatibility((SortOrder)newOrder, (Schema)schema);
        int newOrderId = 1;
        for (SortOrder order : this.sortOrders) {
            if (order.sameOrder(newOrder)) {
                newOrderId = order.orderId();
                break;
            }
            if (newOrderId > order.orderId()) continue;
            newOrderId = order.orderId() + 1;
        }
        if (newOrderId == this.defaultSortOrderId) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.sortOrders);
        if (!this.sortOrdersById.containsKey(newOrderId)) {
            if (newOrder.isUnsorted()) {
                newOrderId = SortOrder.unsorted().orderId();
                builder.add((Object)SortOrder.unsorted());
            } else {
                builder.add((Object)TableMetadata.freshSortOrder(newOrderId, schema, newOrder));
            }
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, newOrderId, (List<SortOrder>)builder.build(), this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata addStagedSnapshot(Snapshot snapshot) {
        ValidationException.check((this.formatVersion == 1 || snapshot.sequenceNumber() > this.lastSequenceNumber ? 1 : 0) != 0, (String)"Cannot add snapshot with sequence number %s older than last sequence number %s", (Object[])new Object[]{snapshot.sequenceNumber(), this.lastSequenceNumber});
        ImmutableList newSnapshots = ImmutableList.builder().addAll(this.snapshots).add((Object)snapshot).build();
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, snapshot.sequenceNumber(), snapshot.timestampMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, (List<Snapshot>)newSnapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata replaceCurrentSnapshot(Snapshot snapshot) {
        if (this.snapshotsById.containsKey(snapshot.snapshotId())) {
            return this.setCurrentSnapshotTo(snapshot);
        }
        ValidationException.check((this.formatVersion == 1 || snapshot.sequenceNumber() > this.lastSequenceNumber ? 1 : 0) != 0, (String)"Cannot add snapshot with sequence number %s older than last sequence number %s", (Object[])new Object[]{snapshot.sequenceNumber(), this.lastSequenceNumber});
        ImmutableList newSnapshots = ImmutableList.builder().addAll(this.snapshots).add((Object)snapshot).build();
        ImmutableList newSnapshotLog = ImmutableList.builder().addAll(this.snapshotLog).add((Object)new SnapshotLogEntry(snapshot.timestampMillis(), snapshot.snapshotId())).build();
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, snapshot.sequenceNumber(), snapshot.timestampMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, snapshot.snapshotId(), (List<Snapshot>)newSnapshots, (List<HistoryEntry>)newSnapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata removeSnapshotsIf(Predicate<Snapshot> removeIf) {
        ArrayList filtered = Lists.newArrayListWithExpectedSize((int)this.snapshots.size());
        for (Snapshot snapshot : this.snapshots) {
            if (snapshot.snapshotId() != this.currentSnapshotId && removeIf.test(snapshot)) continue;
            filtered.add(snapshot);
        }
        HashSet validIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)filtered, Snapshot::snapshotId));
        ArrayList newSnapshotLog = Lists.newArrayList();
        for (HistoryEntry logEntry : this.snapshotLog) {
            if (validIds.contains(logEntry.snapshotId())) {
                newSnapshotLog.add(logEntry);
                continue;
            }
            newSnapshotLog.clear();
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, filtered, (List<HistoryEntry>)ImmutableList.copyOf((Collection)newSnapshotLog), this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    private TableMetadata setCurrentSnapshotTo(Snapshot snapshot) {
        ValidationException.check((boolean)this.snapshotsById.containsKey(snapshot.snapshotId()), (String)"Cannot set current snapshot to unknown: %s", (Object[])new Object[]{snapshot.snapshotId()});
        ValidationException.check((this.formatVersion == 1 || snapshot.sequenceNumber() <= this.lastSequenceNumber ? 1 : 0) != 0, (String)"Last sequence number %s is less than existing snapshot sequence number %s", (Object[])new Object[]{this.lastSequenceNumber, snapshot.sequenceNumber()});
        if (this.currentSnapshotId == snapshot.snapshotId()) {
            return this;
        }
        long nowMillis = System.currentTimeMillis();
        ImmutableList newSnapshotLog = ImmutableList.builder().addAll(this.snapshotLog).add((Object)new SnapshotLogEntry(nowMillis, snapshot.snapshotId())).build();
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, nowMillis, this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, snapshot.snapshotId(), this.snapshots, (List<HistoryEntry>)newSnapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata replaceProperties(Map<String, String> rawProperties) {
        ValidationException.check((rawProperties != null ? 1 : 0) != 0, (String)"Cannot set properties to null", (Object[])new Object[0]);
        Map<String, String> newProperties = TableMetadata.unreservedProperties(rawProperties);
        TableMetadata metadata = new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, newProperties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis, newProperties));
        int newFormatVersion = PropertyUtil.propertyAsInt(rawProperties, "format-version", this.formatVersion);
        if (this.formatVersion != newFormatVersion) {
            metadata = metadata.upgradeToFormatVersion(newFormatVersion);
        }
        return metadata;
    }

    public TableMetadata removeSnapshotLogEntries(Set<Long> snapshotIds) {
        ArrayList newSnapshotLog = Lists.newArrayList();
        for (HistoryEntry logEntry : this.snapshotLog) {
            if (snapshotIds.contains(logEntry.snapshotId())) continue;
            newSnapshotLog.add(logEntry);
        }
        ValidationException.check((this.currentSnapshotId < 0L || ((HistoryEntry)Iterables.getLast((Iterable)newSnapshotLog)).snapshotId() == this.currentSnapshotId ? 1 : 0) != 0, (String)"Cannot set invalid snapshot log: latest entry is not the current snapshot", (Object[])new Object[0]);
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, newSnapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    private PartitionSpec reassignPartitionIds(PartitionSpec partitionSpec, TypeUtil.NextID nextID) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)partitionSpec.schema()).withSpecId(partitionSpec.specId());
        if (this.formatVersion > 1) {
            Map<Pair, Integer> transformToFieldId = this.specs.stream().flatMap(spec -> spec.fields().stream()).collect(Collectors.toMap(field -> Pair.of(field.sourceId(), field.transform().toString()), PartitionField::fieldId, Math::max));
            for (PartitionField field2 : partitionSpec.fields()) {
                int partitionFieldId = transformToFieldId.computeIfAbsent(Pair.of(field2.sourceId(), field2.transform().toString()), k -> nextID.get());
                specBuilder.add(field2.sourceId(), partitionFieldId, field2.name(), field2.transform());
            }
        } else {
            LinkedHashMap newFields = Maps.newLinkedHashMap();
            for (PartitionField newField : partitionSpec.fields()) {
                newFields.put(Pair.of(newField.sourceId(), newField.transform().toString()), newField);
            }
            for (PartitionField field3 : this.spec().fields()) {
                PartitionField newField = (PartitionField)newFields.remove(Pair.of(field3.sourceId(), field3.transform().toString()));
                if (newField != null) {
                    specBuilder.add(newField.sourceId(), field3.fieldId(), newField.name(), newField.transform());
                    continue;
                }
                specBuilder.add(field3.sourceId(), field3.fieldId(), field3.name(), Transforms.alwaysNull());
            }
            for (PartitionField newField : newFields.values()) {
                specBuilder.add(newField.sourceId(), nextID.get(), newField.name(), newField.transform());
            }
        }
        return specBuilder.build();
    }

    public TableMetadata buildReplacement(Schema updatedSchema, PartitionSpec updatedPartitionSpec, SortOrder updatedSortOrder, String newLocation, Map<String, String> updatedProperties) {
        OptionalInt maxOrderId;
        ValidationException.check((this.formatVersion > 1 || PartitionSpec.hasSequentialIds((PartitionSpec)updatedPartitionSpec) ? 1 : 0) != 0, (String)"Spec does not use sequential IDs that are required in v1: %s", (Object[])new Object[]{updatedPartitionSpec});
        AtomicInteger newLastColumnId = new AtomicInteger(this.lastColumnId);
        Schema freshSchema = TypeUtil.assignFreshIds((Schema)updatedSchema, (Schema)this.schema(), newLastColumnId::incrementAndGet);
        OptionalInt maxSpecId = this.specs.stream().mapToInt(PartitionSpec::specId).max();
        int nextSpecId = maxSpecId.orElse(0) + 1;
        PartitionSpec freshSpec = TableMetadata.freshSpec(nextSpecId, freshSchema, updatedPartitionSpec);
        AtomicInteger lastPartitionId = new AtomicInteger(this.lastAssignedPartitionId);
        PartitionSpec newSpec = this.reassignPartitionIds(freshSpec, lastPartitionId::incrementAndGet);
        int specId = this.specs.stream().filter(arg_0 -> ((PartitionSpec)newSpec).compatibleWith(arg_0)).findFirst().map(PartitionSpec::specId).orElse(nextSpecId);
        ImmutableList.Builder specListBuilder = ImmutableList.builder().addAll(this.specs);
        if (!this.specsById.containsKey(specId)) {
            specListBuilder.add((Object)newSpec);
        }
        int nextOrderId = (maxOrderId = this.sortOrders.stream().mapToInt(SortOrder::orderId).max()).isPresent() ? maxOrderId.getAsInt() + 1 : 1;
        int freshSortOrderId = updatedSortOrder.isUnsorted() ? updatedSortOrder.orderId() : nextOrderId;
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(freshSortOrderId, freshSchema, updatedSortOrder);
        Optional<SortOrder> sameSortOrder = this.sortOrders.stream().filter(sortOrder -> sortOrder.sameOrder(freshSortOrder)).findAny();
        int orderId = sameSortOrder.map(SortOrder::orderId).orElse(freshSortOrderId);
        ImmutableList.Builder sortOrdersBuilder = ImmutableList.builder().addAll(this.sortOrders);
        if (!this.sortOrdersById.containsKey(orderId)) {
            sortOrdersBuilder.add((Object)freshSortOrder);
        }
        HashMap newProperties = Maps.newHashMap();
        newProperties.putAll(this.properties);
        newProperties.putAll(TableMetadata.unreservedProperties(updatedProperties));
        int newFormatVersion = PropertyUtil.propertyAsInt(updatedProperties, "format-version", this.formatVersion);
        int freshSchemaId = this.reuseOrCreateNewSchemaId(freshSchema);
        ImmutableList.Builder schemasBuilder = ImmutableList.builder().addAll(this.schemas);
        if (!this.schemasById.containsKey(freshSchemaId)) {
            schemasBuilder.add((Object)new Schema(freshSchemaId, freshSchema.columns(), freshSchema.identifierFieldIds()));
        }
        TableMetadata metadata = new TableMetadata(null, this.formatVersion, this.uuid, newLocation, this.lastSequenceNumber, System.currentTimeMillis(), newLastColumnId.get(), freshSchemaId, (List<Schema>)schemasBuilder.build(), specId, (List<PartitionSpec>)specListBuilder.build(), Math.max(this.lastAssignedPartitionId, newSpec.lastAssignedFieldId()), orderId, (List<SortOrder>)sortOrdersBuilder.build(), (Map<String, String>)ImmutableMap.copyOf((Map)newProperties), -1L, this.snapshots, (List<HistoryEntry>)ImmutableList.of(), this.addPreviousFile(this.file, this.lastUpdatedMillis, newProperties));
        if (this.formatVersion != newFormatVersion) {
            metadata = metadata.upgradeToFormatVersion(newFormatVersion);
        }
        return metadata;
    }

    public TableMetadata updateLocation(String newLocation) {
        return new TableMetadata(null, this.formatVersion, this.uuid, newLocation, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata upgradeToFormatVersion(int newFormatVersion) {
        Preconditions.checkArgument((newFormatVersion <= 2 ? 1 : 0) != 0, (String)"Cannot upgrade table to unsupported format version: v%s (supported: v%s)", (int)newFormatVersion, (int)2);
        Preconditions.checkArgument((newFormatVersion >= this.formatVersion ? 1 : 0) != 0, (String)"Cannot downgrade v%s table to v%s", (int)this.formatVersion, (int)newFormatVersion);
        if (newFormatVersion == this.formatVersion) {
            return this;
        }
        return new TableMetadata(null, newFormatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.currentSchemaId, this.schemas, this.defaultSpecId, this.specs, this.lastAssignedPartitionId, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    private List<MetadataLogEntry> addPreviousFile(InputFile previousFile, long timestampMillis) {
        return this.addPreviousFile(previousFile, timestampMillis, this.properties);
    }

    private List<MetadataLogEntry> addPreviousFile(InputFile previousFile, long timestampMillis, Map<String, String> updatedProperties) {
        ArrayList newMetadataLog;
        if (previousFile == null) {
            return this.previousFiles;
        }
        int maxSize = Math.max(1, PropertyUtil.propertyAsInt(updatedProperties, "write.metadata.previous-versions-max", 100));
        if (this.previousFiles.size() >= maxSize) {
            int removeIndex = this.previousFiles.size() - maxSize + 1;
            newMetadataLog = Lists.newArrayList(this.previousFiles.subList(removeIndex, this.previousFiles.size()));
        } else {
            newMetadataLog = Lists.newArrayList(this.previousFiles);
        }
        newMetadataLog.add(new MetadataLogEntry(timestampMillis, previousFile.location()));
        return newMetadataLog;
    }

    private static PartitionSpec updateSpecSchema(Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)schema).withSpecId(partitionSpec.specId());
        for (PartitionField field : partitionSpec.fields()) {
            specBuilder.add(field.sourceId(), field.fieldId(), field.name(), field.transform());
        }
        return specBuilder.build();
    }

    private static SortOrder updateSortOrderSchema(Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema).withOrderId(sortOrder.orderId());
        for (SortField field : sortOrder.fields()) {
            builder.addSortField(field.transform().toString(), field.sourceId(), field.direction(), field.nullOrder());
        }
        return builder.build();
    }

    private static PartitionSpec freshSpec(int specId, Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)schema).withSpecId(specId);
        for (PartitionField field : partitionSpec.fields()) {
            String sourceName = partitionSpec.schema().findColumnName(field.sourceId());
            specBuilder.add(schema.findField(sourceName).fieldId(), field.fieldId(), field.name(), field.transform().toString());
        }
        return specBuilder.build();
    }

    private static SortOrder freshSortOrder(int orderId, Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema).withOrderId(orderId);
        for (SortField field : sortOrder.fields()) {
            String sourceName = sortOrder.schema().findColumnName(field.sourceId());
            int newSourceId = schema.findField(sourceName).fieldId();
            builder.addSortField(field.transform().toString(), newSourceId, field.direction(), field.nullOrder());
        }
        return builder.build();
    }

    private static Map<Long, Snapshot> indexAndValidateSnapshots(List<Snapshot> snapshots, long lastSequenceNumber) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Snapshot snap : snapshots) {
            ValidationException.check((snap.sequenceNumber() <= lastSequenceNumber ? 1 : 0) != 0, (String)"Invalid snapshot with sequence number %s greater than last sequence number %s", (Object[])new Object[]{snap.sequenceNumber(), lastSequenceNumber});
            builder.put((Object)snap.snapshotId(), (Object)snap);
        }
        return builder.build();
    }

    private Map<Integer, Schema> indexSchemas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Schema schema : this.schemas) {
            builder.put((Object)schema.schemaId(), (Object)schema);
        }
        return builder.build();
    }

    private static Map<Integer, PartitionSpec> indexSpecs(List<PartitionSpec> specs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PartitionSpec spec : specs) {
            builder.put((Object)spec.specId(), (Object)spec);
        }
        return builder.build();
    }

    private static Map<Integer, SortOrder> indexSortOrders(List<SortOrder> sortOrders) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SortOrder sortOrder : sortOrders) {
            builder.put((Object)sortOrder.orderId(), (Object)sortOrder);
        }
        return builder.build();
    }

    private int reuseOrCreateNewSchemaId(Schema newSchema) {
        int newSchemaId = this.currentSchemaId;
        for (Schema schema : this.schemas) {
            if (schema.sameSchema(newSchema)) {
                newSchemaId = schema.schemaId();
                break;
            }
            if (schema.schemaId() < newSchemaId) continue;
            newSchemaId = schema.schemaId() + 1;
        }
        return newSchemaId;
    }

    public static class MetadataLogEntry {
        private final long timestampMillis;
        private final String file;

        MetadataLogEntry(long timestampMillis, String file) {
            this.timestampMillis = timestampMillis;
            this.file = file;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }

        public String file() {
            return this.file;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetadataLogEntry)) {
                return false;
            }
            MetadataLogEntry that = (MetadataLogEntry)other;
            return this.timestampMillis == that.timestampMillis && java.util.Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestampMillis, this.file});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timestampMillis", this.timestampMillis).add("file", (Object)this.file).toString();
        }
    }

    public static class SnapshotLogEntry
    implements HistoryEntry {
        private final long timestampMillis;
        private final long snapshotId;

        SnapshotLogEntry(long timestampMillis, long snapshotId) {
            this.timestampMillis = timestampMillis;
            this.snapshotId = snapshotId;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SnapshotLogEntry)) {
                return false;
            }
            SnapshotLogEntry that = (SnapshotLogEntry)other;
            return this.timestampMillis == that.timestampMillis && this.snapshotId == that.snapshotId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestampMillis, this.snapshotId});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timestampMillis", this.timestampMillis).add("snapshotId", this.snapshotId).toString();
        }
    }
}

