/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

interface ManifestEntry<F extends ContentFile<F>> {
    public static final Types.NestedField STATUS = Types.NestedField.required((int)0, (String)"status", (Type)Types.IntegerType.get());
    public static final Types.NestedField SNAPSHOT_ID = Types.NestedField.optional((int)1, (String)"snapshot_id", (Type)Types.LongType.get());
    public static final Types.NestedField SEQUENCE_NUMBER = Types.NestedField.optional((int)3, (String)"sequence_number", (Type)Types.LongType.get());
    public static final int DATA_FILE_ID = 2;

    public static Schema getSchema(Types.StructType partitionType) {
        return ManifestEntry.wrapFileSchema(DataFile.getType((Types.StructType)partitionType));
    }

    public static Schema wrapFileSchema(Types.StructType fileType) {
        return new Schema(new Types.NestedField[]{STATUS, SNAPSHOT_ID, SEQUENCE_NUMBER, Types.NestedField.required((int)2, (String)"data_file", (Type)fileType)});
    }

    public Status status();

    public Long snapshotId();

    public void setSnapshotId(long var1);

    public Long sequenceNumber();

    public void setSequenceNumber(long var1);

    public F file();

    public ManifestEntry<F> copy();

    public ManifestEntry<F> copyWithoutStats();

    public static enum Status {
        EXISTING(0),
        ADDED(1),
        DELETED(2);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

