/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class RowIsNull
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES_NULL = new Clause[]{Clause.CONDITION, Clause.CONDITION_IS_NULL};
    private static final Clause[] CLAUSES_NOT_NULL = new Clause[]{Clause.CONDITION, Clause.CONDITION_IS_NOT_NULL};
    private static final Set<SQLDialect> EMULATE_NULL = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private final Row row;
    private final boolean isNull;

    RowIsNull(Row row, boolean isNull) {
        this.row = row;
        this.isNull = isNull;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (EMULATE_NULL.contains((Object)configuration.family())) {
            Field<?>[] fields = this.row.fields();
            ArrayList<Condition> conditions = new ArrayList<Condition>(fields.length);
            for (Field<?> field : fields) {
                conditions.add(this.isNull ? field.isNull() : field.isNotNull());
            }
            Condition result = DSL.and(conditions);
            return (QueryPartInternal)((Object)result);
        }
        return new Native();
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -2977241780111574353L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(RowIsNull.this.row).sql(' ').visit(RowIsNull.this.isNull ? Keywords.K_IS_NULL : Keywords.K_IS_NOT_NULL);
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return RowIsNull.this.isNull ? CLAUSES_NULL : CLAUSES_NOT_NULL;
        }
    }
}

