/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="druid")
public class DruidStoragePluginConfig
extends StoragePluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(DruidStoragePluginConfig.class);
    public static final String NAME = "druid";
    private static final int DEFAULT_AVERAGE_ROW_SIZE_BYTES = 100;
    private final String brokerAddress;
    private final String coordinatorAddress;
    private final int averageRowSizeBytes;

    @JsonCreator
    public DruidStoragePluginConfig(@JsonProperty(value="brokerAddress") String brokerAddress, @JsonProperty(value="coordinatorAddress") String coordinatorAddress, @JsonProperty(value="averageRowSizeBytes") Integer averageRowSizeBytes) {
        this.brokerAddress = brokerAddress;
        this.coordinatorAddress = coordinatorAddress;
        this.averageRowSizeBytes = averageRowSizeBytes == null ? 100 : averageRowSizeBytes;
        logger.debug("Broker Address - {}, Coordinator Address - {}, averageRowSizeBytes - {}", new Object[]{brokerAddress, coordinatorAddress, averageRowSizeBytes});
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        DruidStoragePluginConfig thatConfig = (DruidStoragePluginConfig)((Object)that);
        return Objects.equals(this.brokerAddress, thatConfig.brokerAddress) && Objects.equals(this.coordinatorAddress, thatConfig.coordinatorAddress);
    }

    public int hashCode() {
        return Objects.hash(this.brokerAddress, this.coordinatorAddress);
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public String getCoordinatorAddress() {
        return this.coordinatorAddress;
    }

    public int getAverageRowSizeBytes() {
        return this.averageRowSizeBytes;
    }
}

