/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.i18n;

import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.util.i18n.OracleUpperTable;

public class OracleUpper {
    private OracleUpper() {
    }

    public static String toUpperCase(OracleUpperTable t, String value) {
        char[] exceptions = t.getUpperCaseExceptions();
        if (exceptions.length > 0) {
            int nextExceptionIndex;
            int n = nextExceptionIndex = exceptions.length == 1 ? value.indexOf(exceptions[0]) : StringUtils.indexOfAny((CharSequence)value, (char[])exceptions);
            if (nextExceptionIndex >= 0) {
                StringBuilder result = new StringBuilder(value.length());
                String rem = value;
                do {
                    char nextException = rem.charAt(nextExceptionIndex);
                    result.append(rem.substring(0, nextExceptionIndex).toUpperCase(t.getLocale()));
                    result.append(t.getUpperCaseExceptionMapping(nextException));
                    rem = rem.substring(nextExceptionIndex + 1);
                } while ((nextExceptionIndex = exceptions.length == 1 ? rem.indexOf(exceptions[0]) : StringUtils.indexOfAny((CharSequence)rem, (char[])exceptions)) >= 0);
                result.append(rem.toUpperCase(t.getLocale()));
                return result.toString();
            }
        }
        return value.toUpperCase(t.getLocale());
    }
}

