/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.csv;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Splitter;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.csv.CsvUpsertExecutor;

class StringToArrayConverter {
    private final Splitter splitter;
    private final Connection conn;
    private final PDataType elementDataType;
    private final CsvUpsertExecutor.SimpleDatatypeConversionFunction elementConvertFunction;

    public StringToArrayConverter(Connection conn, String separatorString, PDataType elementDataType) {
        this.conn = conn;
        this.splitter = Splitter.on((String)separatorString);
        this.elementDataType = elementDataType;
        this.elementConvertFunction = new CsvUpsertExecutor.SimpleDatatypeConversionFunction(elementDataType, this.conn);
    }

    public Array toArray(String input) throws SQLException {
        if (input == null || input.isEmpty()) {
            return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), new Object[0]);
        }
        return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.splitter.split((CharSequence)input), (Function)this.elementConvertFunction)).toArray());
    }
}

