/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.util.ByteUtil;

public class StatisticsCollectionRunTracker {
    private static volatile StatisticsCollectionRunTracker INSTANCE;
    private final Set<ColumnFamilyRegionInfo> updateStatsRegions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<RegionInfo> compactingRegions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ExecutorService executor;
    public static final long CONCURRENT_UPDATE_STATS_ROW_COUNT = -100L;
    public static final long COMPACTION_UPDATE_STATS_ROW_COUNT = -200L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticsCollectionRunTracker getInstance(Configuration config) {
        StatisticsCollectionRunTracker result = INSTANCE;
        if (result != null) return result;
        Class<StatisticsCollectionRunTracker> clazz = StatisticsCollectionRunTracker.class;
        synchronized (StatisticsCollectionRunTracker.class) {
            result = INSTANCE;
            if (result != null) return result;
            INSTANCE = result = new StatisticsCollectionRunTracker(config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private StatisticsCollectionRunTracker(Configuration config) {
        int poolSize = config.getInt("phoenix.stats.pool.size", 4);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("phoenix-update-statistics-%s");
        this.executor = Executors.newFixedThreadPool(poolSize, builder.build());
    }

    public boolean addCompactingRegion(RegionInfo regionInfo) {
        return this.compactingRegions.add(regionInfo);
    }

    public boolean removeCompactingRegion(RegionInfo regionInfo) {
        return this.compactingRegions.remove(regionInfo);
    }

    public boolean areStatsBeingCollectedOnCompaction(RegionInfo regionInfo) {
        return this.compactingRegions.contains(regionInfo);
    }

    public boolean addUpdateStatsCommandRegion(RegionInfo regionInfo, Set<byte[]> familySet) {
        return this.updateStatsRegions.add(new ColumnFamilyRegionInfo(regionInfo, familySet));
    }

    public boolean removeUpdateStatsCommandRegion(RegionInfo regionInfo, Set<byte[]> familySet) {
        return this.updateStatsRegions.remove(new ColumnFamilyRegionInfo(regionInfo, familySet));
    }

    public <T> Future<T> runTask(Callable<T> c) {
        return this.executor.submit(c);
    }

    private static class ColumnFamilyRegionInfo {
        private final RegionInfo regionInfo;
        private final Set<byte[]> familySet;

        public ColumnFamilyRegionInfo(RegionInfo regionInfo, Set<byte[]> familySet) {
            this.regionInfo = regionInfo;
            this.familySet = familySet;
        }

        public RegionInfo getRegionInfo() {
            return this.regionInfo;
        }

        public Set<byte[]> getFamilySet() {
            return this.familySet;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ColumnFamilyRegionInfo)) {
                return false;
            }
            ColumnFamilyRegionInfo c = (ColumnFamilyRegionInfo)obj;
            return c.getRegionInfo().equals(this.regionInfo) && ByteUtil.match(this.familySet, c.getFamilySet());
        }

        public int hashCode() {
            return this.getRegionInfo().hashCode();
        }
    }
}

