/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.replication;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.SchemaUtil;

public class SystemCatalogWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private boolean skipCellFilter;
    private static final byte[] CHILD_TABLE_BYTES = new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()};
    private static final int NUM_COLUMNS_PRIMARY_KEY = 5;

    public WAL.Entry filter(WAL.Entry entry) {
        this.skipCellFilter = !SchemaUtil.isMetaTable(entry.getKey().getTableName().getName()) && !SchemaUtil.isChildLinkTable(entry.getKey().getTableName().getName());
        return entry;
    }

    public Cell filterCell(WAL.Entry entry, Cell cell) {
        if (this.skipCellFilter) {
            return cell;
        }
        if (SchemaUtil.isMetaTable(entry.getKey().getTableName().getName())) {
            return this.isTenantIdLeadingInKey(cell) ? cell : null;
        }
        return this.isTenantRowCellSystemChildLink(cell) ? cell : null;
    }

    private boolean isTenantIdLeadingInKey(Cell cell) {
        return cell.getRowArray()[cell.getRowOffset()] != 0;
    }

    private boolean isTenantRowCellSystemChildLink(Cell cell) {
        boolean isChildLink;
        boolean isTenantRowCell = this.isTenantIdLeadingInKey(cell);
        ImmutableBytesWritable key = new ImmutableBytesWritable(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
        boolean isChildLinkToTenantView = false;
        if (!isTenantRowCell && ((isChildLink = CellUtil.matchingQualifier((Cell)cell, (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES)) && CellUtil.matchingValue((Cell)cell, (byte[])CHILD_TABLE_BYTES) || CellUtil.isDeleteFamily((Cell)cell))) {
            byte[][] rowViewKeyMetadata = new byte[5][];
            SchemaUtil.getVarChars(key.get(), key.getOffset(), key.getLength(), 0, rowViewKeyMetadata);
            isChildLinkToTenantView = rowViewKeyMetadata[3].length != 0;
        }
        return isTenantRowCell || isChildLinkToTenantView;
    }
}

